/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.quartz.listener;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.schedule.util.DistributedScheduleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;

public class WorkerKeyExpirationListener
implements MessageListener {
    Logger log = LoggerFactory.getLogger(WorkerKeyExpirationListener.class);

    public void onMessage(Message message, byte[] pattern) {
        try {
            String event = message.toString();
            if (event.equals("expired")) {
                String workerKey = new String(pattern);
                workerKey = workerKey.substring(workerKey.lastIndexOf("DWQuartz::worker::"));
                this.log.info(workerKey + "  worker was offline!!");
                DistributedScheduleUtils.onlineWorkers.remove(workerKey);
                if (!DWApplicationConfigUtils.getProperty((String)"distributedScheduleWorkerId").equals(workerKey)) {
                    DistributedScheduleUtils.refreshStoppedSchedule();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

