/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.dbservice;

import com.digiwin.app.container.exceptions.DWI18NExceptionUtils;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataRowCollection;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.schedule.entity.DWScheduleQuartzInfo;
import com.digiwin.app.schedule.util.DWScheduleCastUtils;
import com.digiwin.utils.DWTenantUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class DWScheduleDBService {
    @Autowired
    private DWDao dao;
    private static String tenantSqlTag = DWTenantUtils.getTenantTagByColumnName();
    @Deprecated
    private final String querySQL = "select * from dw_schedule ";
    @Deprecated
    private final String updateSQL = "update  from dw_schedule ";
    private final String deleteSQL = "delete from dw_schedule where schedule_id = ? " + tenantSqlTag;
    private final String updateStatusSQL = "update dw_schedule set enable_status = ? where schedule_id = ? " + tenantSqlTag;
    private final String tableName = "dw_schedule";
    private static DWScheduleDBService instance = null;

    public static DWScheduleDBService getInstance() {
        return instance;
    }

    public static void setInstance(DWScheduleDBService instance) {
        DWScheduleDBService.instance = instance;
    }

    public Object updateScheduleByDataSet(DWDataSet dataSet) throws Exception {
        return this.dao.execute(dataSet);
    }

    public int deleteSchedule(String scheduleId) throws Exception {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        return this.dao.update((IDWSQLOptions)option, this.deleteSQL, new Object[]{scheduleId});
    }

    public Object getScheduleList(DWPagableQueryInfo queryInfo) throws Exception {
        queryInfo.setTableName("dw_schedule");
        return this.dao.select((DWQueryInfo)queryInfo);
    }

    public DWDataRow getScheduleInfo(String scheduleId) throws Exception {
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_schedule");
        queryInfo.addEqualInfo("schedule_id", (Object)scheduleId);
        return this.dao.selectOne(queryInfo, new DWDataSetOperationOption());
    }

    public int enableSchedule(String id) throws Exception {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        return this.dao.update((IDWSQLOptions)option, this.updateStatusSQL, new Object[]{"Y", id});
    }

    public int disableSchedule(String id) throws Exception {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        return this.dao.update((IDWSQLOptions)option, this.updateStatusSQL, new Object[]{"N", id});
    }

    public DWScheduleQuartzInfo queryDWScheduleQuartzInfo(String scheduleId) throws Exception {
        DWScheduleQuartzInfo quartzInfo = null;
        DWDataRow scheduleInfo = this.getScheduleInfo(scheduleId);
        if (scheduleInfo != null) {
            quartzInfo = DWScheduleCastUtils.convertDataRowToScheduleQuartzInfo(scheduleInfo);
        }
        return quartzInfo;
    }

    public void assertExistedSchedule(List<String> scheduleIds) throws Exception {
        ArrayList<String> scheduleLst = new ArrayList<String>(scheduleIds);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        DWQueryInfo queryInfo = new DWQueryInfo("dw_schedule");
        DWQueryCondition condition = new DWQueryCondition();
        condition.addFieldInfo("schedule_id", DWQueryValueOperator.In, scheduleLst.toArray());
        queryInfo.setCondition(condition);
        DWDataSet result = this.dao.select(queryInfo, option);
        DWDataRowCollection rows = result.getTable("dw_schedule").getRows();
        for (DWDataRow row : rows) {
            scheduleLst.remove(row.get("schedule_id"));
        }
        if (scheduleLst.toArray().length > 0) {
            DWI18NExceptionUtils.throwDWException((String)"12001", (Object[])scheduleLst.toArray());
        }
    }
}

