/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.dbservice;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.utils.DWTenantUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DWScheduleTimeDBService {
    @Autowired
    private DWDao dao;
    private static String tenantSqlTag = DWTenantUtils.getTenantTagByColumnName();
    private final String deleteSQL = "delete from dw_schedule_time where schedule_id = ? " + tenantSqlTag;
    @Deprecated
    private final String deleteRRuleSQL = "delete from dw_schedule_time_rrule where schedule_id = ? " + tenantSqlTag;
    @Deprecated
    private final String querySQL = "select * from dw_schedule_time ";
    @Deprecated
    private final String queryRRuleSQL = "select * from dw_schedule_time_rrule ";
    private final String tableName = "dw_schedule_time";
    private static DWScheduleTimeDBService instance = null;

    public static DWScheduleTimeDBService getInstance() {
        return instance;
    }

    public static void setInstance(DWScheduleTimeDBService instance) {
        DWScheduleTimeDBService.instance = instance;
    }

    public int deleteScheduleTime(String scheduleId) throws Exception {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        return this.dao.update((IDWSQLOptions)option, this.deleteSQL, new Object[]{scheduleId});
    }

    @Deprecated
    public int deleteScheduleTimeRRule(String scheduleId) throws Exception {
        return this.dao.update(this.deleteRRuleSQL, new Object[]{scheduleId});
    }

    public DWDataRow getScheduleTimeInfo(String scheduleId) throws Exception {
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_schedule_time");
        queryInfo.addEqualInfo("schedule_id", (Object)scheduleId);
        return this.dao.selectOne(queryInfo, new DWDataSetOperationOption());
    }

    @Deprecated
    public DWDataRow getScheduleTimeRRuleInfo(String scheduleId) throws Exception {
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.addEqualInfo("schedule_id", (Object)scheduleId);
        return this.dao.selectOne(queryInfo, "select * from dw_schedule_time_rrule ", new DWDataSetOperationOption());
    }
}

