/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import com.digiwin.app.schedule.entity.UpdateBatchPojo;
import com.digiwin.app.schedule.quartz.jdbcjobstore.DWJobStore;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.impl.matchers.GroupMatcher;

public class DWQuartzScheduler
extends QuartzScheduler {
    public DWQuartzScheduler(QuartzSchedulerResources resources, long idleWaitTime, long dbRetryInterval) throws SchedulerException {
        super(resources, idleWaitTime, dbRetryInterval);
    }

    public void deleteBeforeStoreJobsAndTriggers(List<UpdateBatchPojo> updateBatchPojos, boolean replace) throws SchedulerException {
        QuartzSchedulerResources resources;
        Field field;
        this.validateState();
        try {
            field = DWQuartzScheduler.class.getSuperclass().getDeclaredField("resources");
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new SchedulerException((Throwable)e);
        }
        field.setAccessible(true);
        try {
            resources = (QuartzSchedulerResources)field.get((Object)this);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new SchedulerException((Throwable)e);
        }
        DWJobStore jobStore = (DWJobStore)resources.getJobStore();
        jobStore.deleteBeforeStoreJobsAndTriggers(updateBatchPojos, replace);
        this.notifySchedulerThread(0L);
        for (UpdateBatchPojo updateBatchPojo : updateBatchPojos) {
            Map<JobDetail, Set<? extends Trigger>> triggersAndJobs = updateBatchPojo.getTriggersAndJobs();
            for (JobDetail jobDetail : triggersAndJobs.keySet()) {
                Set jobKeys;
                JobKey key = jobDetail.getKey();
                int scheduleType = updateBatchPojo.getScheduleType();
                if (1 == scheduleType) {
                    List triggers = resources.getJobStore().getTriggersForJob(key);
                    if (triggers.size() <= 0) continue;
                    for (int i = 0; i < triggers.size(); ++i) {
                        this.notifySchedulerListenersUnscheduled(((Trigger)triggers.get(i)).getKey());
                    }
                    continue;
                }
                String scheduleId = updateBatchPojo.getScheduleId();
                GroupMatcher matcher = GroupMatcher.jobGroupEquals((String)scheduleId);
                if (matcher == null) {
                    matcher = GroupMatcher.groupEquals((String)"DEFAULT");
                }
                if ((jobKeys = resources.getJobStore().getJobKeys(matcher)) == null || jobKeys.size() <= 0) continue;
                for (JobKey jobKey : jobKeys) {
                    this.notifySchedulerListenersJobDeleted(jobKey);
                }
            }
            for (Map.Entry entry : triggersAndJobs.entrySet()) {
                JobDetail job = (JobDetail)entry.getKey();
                if (job == null) continue;
                this.notifySchedulerListenersJobAdded(job);
                Set triggers = (Set)entry.getValue();
                if (triggers == null) continue;
                for (Trigger trigger : triggers) {
                    this.notifySchedulerThread(trigger.getNextFireTime().getTime());
                    this.notifySchedulerListenersSchduled(trigger);
                }
            }
        }
    }
}

