/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.quartz.listener;

import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.schedule.dbservice.DWScheduleDBService;
import com.digiwin.app.schedule.dbservice.DWScheduleRecordDBService;
import com.digiwin.app.schedule.quartz.DWQuartz;
import com.digiwin.app.schedule.util.DWScheduleExceptionUtils;
import com.digiwin.app.schedule.util.DWScheduleServiceContextUtil;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.utils.DWTenantUtils;
import com.google.gson.Gson;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;

public class DWQuartzJobListener
implements JobListener {
    private static final String CLASS_TAG = "[DWSchedule.DWQuartzJobListener]";
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String JOB_LISTENER_NAME = "DWQuartzJobListener";
    private DWScheduleRecordDBService recordService = DWScheduleRecordDBService.getInstance();
    private DWScheduleDBService scheduleDBService = DWScheduleDBService.getInstance();
    private static boolean tenantEnabled = DWTenantUtils.isTenantenabled();
    private static String tenantColumnName = DWTenantUtils.getTenantColumnName();
    private static String IAM_TENANTSID = "tenantSid";
    private static String IAM_USERID = "userId";
    private static String _SCHEDULEID = "schedule";
    private Gson gson = new Gson();

    public String getName() {
        return JOB_LISTENER_NAME;
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        try {
            JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
            String scheduleId = jobDataMap.getString("schedule_id");
            String jobName = jobDataMap.getString("job_name");
            Object scheduleParam = jobDataMap.get((Object)"schedule_param");
            String scheduleType = jobDataMap.getString("schedule_type");
            String execUserId = jobDataMap.getString("dw_schedule_exec_userid");
            String scheduleName = jobDataMap.getString("schedule_name");
            String programCode = jobDataMap.getString("program_code");
            String excludeDate = jobDataMap.getString("exclude_date");
            String excludeTime = jobDataMap.getString("exclude_time");
            String isRetry = jobDataMap.getString("is_retry");
            JobDataMap triggerJobDataMap = context.getTrigger().getJobDataMap();
            DWScheduleServiceContextUtil.initProfile(jobDataMap);
            String isMisfire = "false";
            if (triggerJobDataMap.containsKey((Object)"is_misfire") && "true".equals(isMisfire = triggerJobDataMap.getString("is_misfire"))) {
                this.log.info((Object)("[DWSchedule.DWQuartzJobListener] scheduleId: " + scheduleId + " jobName: " + jobName + ", isMisfire: true"));
                if ("N".equalsIgnoreCase(isRetry)) {
                    this.log.info((Object)("[DWSchedule.DWQuartzJobListener] scheduleId: " + scheduleId + " jobName: " + jobName + ", isRetry is N, ignore retry"));
                    jobDataMap.put("isExclude", true);
                    return;
                }
            }
            String executeStatus = "running";
            if (excludeDate != null && this.isTodayExcludeDate(excludeDate)) {
                this.log.info((Object)("[DWSchedule.DWQuartzJobListener] scheduleId: " + scheduleId + " jobName: " + jobName + " exclude!!!"));
                jobDataMap.put("isExclude", true);
                executeStatus = "exclude";
            }
            if (excludeTime != null && this.isNowExcludeTime(excludeTime)) {
                this.log.info((Object)("[DWSchedule.DWQuartzJobListener] scheduleId: " + scheduleId + " jobName: " + jobName + " exclude!!!"));
                jobDataMap.put("isExclude", true);
                executeStatus = "exclude";
            }
            long now = new Date().getTime();
            jobDataMap.put("start_time", now);
            String executeId = jobDataMap.getString("execute_id");
            DWDataSet dataSet = new DWDataSet();
            DWDataRow recordRow = dataSet.newTable("dw_schedule_record").newRow();
            recordRow.set("$state", (Object)"C");
            recordRow.set("schedule_id", (Object)scheduleId);
            recordRow.set("execute_id", (Object)executeId);
            recordRow.set("execute_status", (Object)executeStatus);
            recordRow.set("start_time", (Object)new Timestamp(now));
            recordRow.set("schedule_param", (Object)this.gson.toJson(scheduleParam));
            recordRow.set("job_name", (Object)jobName);
            recordRow.set("schedule_type", (Object)scheduleType);
            recordRow.set("schedule_name", (Object)scheduleName);
            recordRow.set("program_code", (Object)programCode);
            recordRow.set("is_misfire", (Object)("true".equals(isMisfire) ? "Y" : "N"));
            String executor = DWQuartz.getSchedulerName();
            if ("0".equals(scheduleType)) {
                executor = execUserId;
            }
            recordRow.set("executor", (Object)executor);
            this.recordService.updateByDataSet(dataSet);
        }
        catch (Exception e) {
            DWScheduleExceptionUtils.log(this.log, CLASS_TAG, e);
        }
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        DWScheduleServiceContextUtil.initProfile(jobDataMap);
        boolean isExclude = jobDataMap.getBoolean("isExclude");
        if (isExclude) {
            return;
        }
        String exeStatus = jobDataMap.getString("execute_status");
        if (exeStatus == null) {
            exeStatus = "completed";
        }
        String executeId = jobDataMap.getString("execute_id");
        String scheduleId = jobDataMap.getString("schedule_id");
        Object message = jobDataMap.get((Object)"message");
        Object messageDetail = jobDataMap.get((Object)"message_detail");
        long startTime = jobDataMap.get((Object)"start_time") == null ? new Date().getTime() : jobDataMap.getLong("start_time");
        Date now = new Date();
        try {
            DWDataSet dataSet = new DWDataSet();
            DWDataRow recordRow = dataSet.newTable("dw_schedule_record").newRow();
            recordRow.set("$state", (Object)"U");
            recordRow.set("execute_id", (Object)executeId);
            recordRow.set("execute_status", (Object)exeStatus);
            recordRow.set("start_time", (Object)new Timestamp(startTime));
            recordRow.set("end_time", (Object)new Timestamp(now.getTime()));
            recordRow.set("message", message);
            recordRow.set("message_detail", messageDetail);
            DWDataRow scheduleRow = dataSet.newTable("dw_schedule").newRow();
            Date nextTime = context.getNextFireTime();
            scheduleRow.set("schedule_id", (Object)scheduleId);
            scheduleRow.set("recent_status", (Object)exeStatus);
            scheduleRow.set("next_execute_time", (Object)nextTime);
            scheduleRow.set("$state", (Object)"U");
            if (exeStatus.equals("completed")) {
                long periodTime = context.getJobRunTime();
                scheduleRow.set("last_success_time", (Object)new Timestamp(now.getTime()));
                scheduleRow.set("last_period_time", (Object)periodTime);
            }
            this.scheduleDBService.updateScheduleByDataSet(dataSet);
        }
        catch (Exception e) {
            DWScheduleExceptionUtils.log(this.log, CLASS_TAG, e);
        }
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        DWScheduleServiceContextUtil.initProfile(jobDataMap);
        boolean isExclude = jobDataMap.getBoolean("isExclude");
        if (isExclude) {
            return;
        }
        String scheduleId = jobDataMap.getString("schedule_id");
        String jobName = jobDataMap.getString("job_name");
        Object scheduleParam = jobDataMap.get((Object)"schedule_param");
        long startTime = jobDataMap.get((Object)"start_time") == null ? new Date().getTime() : jobDataMap.getLong("start_time");
        try {
            Date now = new Date();
            String executeId = jobDataMap.get((Object)"execute_id").toString();
            DWDataSet dataSet = new DWDataSet();
            DWDataRow recordRow = dataSet.newTable("dw_schedule_record").newRow();
            recordRow.set("execute_id", (Object)executeId);
            recordRow.set("schedule_id", (Object)scheduleId);
            recordRow.set("schedule_name", (Object)jobDataMap.getString("schedule_name"));
            recordRow.set("schedule_type", (Object)jobDataMap.getString("schedule_type"));
            recordRow.set("program_code", (Object)jobDataMap.getString("program_code"));
            recordRow.set("job_name", (Object)jobName);
            recordRow.set("execute_status", (Object)"skipped");
            recordRow.set("start_time", (Object)new Timestamp(startTime));
            recordRow.set("schedule_param", (Object)new Gson().toJson(scheduleParam));
            recordRow.set("end_time", (Object)new Timestamp(now.getTime()));
            DWDataRow row = dataSet.newTable("dw_schedule").newRow();
            row.set("recent_status", (Object)"skipped");
            row.set("schedule_id", (Object)scheduleId);
            row.set("$state", (Object)"U");
            this.recordService.updateByDataSet(dataSet);
        }
        catch (Exception e) {
            DWScheduleExceptionUtils.log(this.log, CLASS_TAG, e);
        }
    }

    @Deprecated
    private void processTenant(DWDataRow recordRow, JobDataMap jobDataMap) {
        HashMap<String, Object> profile = new HashMap<String, Object>();
        if (tenantEnabled) {
            recordRow.set(tenantColumnName, jobDataMap.get((Object)tenantColumnName));
            if (jobDataMap.containsKey((Object)tenantColumnName)) {
                profile.put(IAM_TENANTSID, jobDataMap.get((Object)tenantColumnName));
            } else {
                this.log.error((Object)String.format("[DWSchedule.DWQuartzJobListener][jobToBeExecuted] %s is missing in jobDataMap", tenantColumnName));
            }
            if (jobDataMap.containsKey((Object)"tenantId")) {
                profile.put("tenantId", jobDataMap.get((Object)"tenantId"));
            }
            if (jobDataMap.containsKey((Object)"dw_schedule_exec_userid") && jobDataMap.get((Object)"dw_schedule_exec_userid") != null) {
                profile.put(IAM_USERID, jobDataMap.get((Object)"dw_schedule_exec_userid"));
            }
        } else {
            profile.put(IAM_USERID, _SCHEDULEID);
        }
        DWServiceContext.getContext().setProfile(profile);
    }

    private boolean isTodayExcludeDate(String excludeDate) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMdd");
        String today = dateFormat.format(new Date());
        if (today.equals(excludeDate)) {
            this.log.info((Object)("[DWSchedule.DWQuartzJobListener] today is " + excludeDate + " and excludeDate is " + excludeDate));
            return true;
        }
        return false;
    }

    private boolean isNowExcludeTime(String excludeTime) throws Exception {
        String[] elements;
        Date now = new Date();
        for (String element : elements = excludeTime.split(",")) {
            SimpleDateFormat dateFormat = new SimpleDateFormat();
            dateFormat = element.contains(" ") ? new SimpleDateFormat("MMdd HHmmss") : new SimpleDateFormat("HHmmss");
            now = dateFormat.parse(dateFormat.format(now));
            String[] stratEnd = element.split("-");
            String strat = stratEnd[0];
            String end = stratEnd[1];
            Date startDate = dateFormat.parse(strat);
            Date endDate = dateFormat.parse(end);
            if (now.compareTo(startDate) < 0 || now.compareTo(endDate) > 0) continue;
            this.log.info((Object)("[DWSchedule.DWQuartzJobListener] now is " + dateFormat.format(now) + " and excludeTime is " + dateFormat.format(startDate) + " ~ " + dateFormat.format(endDate)));
            return true;
        }
        return false;
    }
}

