/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.util;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.schedule.DWDistributedScheduleProperties;
import com.digiwin.app.schedule.DWDistributedScheduleWorkersProperties;
import com.digiwin.app.schedule.DWScheduleProperties;
import com.digiwin.app.schedule.dbservice.DWScheduleDistributeWorkerConfigService;
import com.digiwin.app.schedule.entity.DWScheduleQuartzInfo;
import com.digiwin.app.schedule.exception.DistributedScheduleException;
import com.digiwin.app.schedule.quartz.DWQuartz;
import com.digiwin.app.schedule.quartz.jdbcjobstore.DWJobStore;
import com.digiwin.app.schedule.util.DWScheduleHttpClient;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.utils.DWTenantUtils;
import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.quartz.Trigger;
import org.quartz.core.DWQuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.impl.DWStdScheduler;

public class DistributedScheduleUtils {
    private static final String CLASS_TAG = "[DWSchedule.DistributedScheduleUtils]";
    private static Log log = LogFactory.getLog(DistributedScheduleUtils.class);
    public static Map onlineWorkers = new ConcurrentHashMap();
    public static final String redisWorkerKeyPrefix = "DWQuartz::worker::";
    public static final String redisSubscribeWorkers = "DWQuartz::subscribe::workers";
    public static final String redisScheduleExecutors = "DWQuartz::config::executors";
    public static final String redisScheduleTriggerRecords = "DWQuartz::trigger::records";
    public static DWDistributedScheduleWorkersProperties.DWDistributedScheduleWorkerProperties workerProperties;

    private static DWDistributedScheduleProperties getProperties() {
        return DWScheduleProperties.getDefaultProperties().getDistributedScheduleProperties();
    }

    public static boolean isSimpleMaster() {
        DWDistributedScheduleProperties distributedScheduleProperties = DistributedScheduleUtils.getProperties();
        boolean distributedScheduleEnable = distributedScheduleProperties.isEnabled();
        boolean distributedScheduleSimpleMaster = distributedScheduleProperties.isSimpleMaster();
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] isSimpleMaster: " + (distributedScheduleEnable && distributedScheduleSimpleMaster)));
        return distributedScheduleEnable && distributedScheduleSimpleMaster;
    }

    public static boolean isHigherMaster() {
        DWDistributedScheduleProperties distributedScheduleProperties = DistributedScheduleUtils.getProperties();
        boolean distributedScheduleEnable = distributedScheduleProperties.isEnabled();
        boolean distributedScheduleHigherMaster = distributedScheduleProperties.isHigherMaster();
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] isHigherMaster: " + (distributedScheduleEnable && distributedScheduleHigherMaster)));
        return distributedScheduleEnable && distributedScheduleHigherMaster;
    }

    public static boolean isMaster() {
        boolean isSimpleMaster = DistributedScheduleUtils.isSimpleMaster();
        boolean isHigherMaster = DistributedScheduleUtils.isHigherMaster();
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] isMaster: " + (isSimpleMaster || isHigherMaster)));
        return isSimpleMaster || isHigherMaster;
    }

    public static boolean isWorker() {
        DWDistributedScheduleProperties distributedScheduleProperties = DistributedScheduleUtils.getProperties();
        boolean distributedScheduleEnable = distributedScheduleProperties.isEnabled();
        boolean distributedScheduleWorker = distributedScheduleProperties.isWorker();
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] isWorker: " + (distributedScheduleEnable && distributedScheduleWorker)));
        return distributedScheduleEnable && distributedScheduleWorker;
    }

    public static boolean isAp() {
        DWDistributedScheduleProperties distributedScheduleProperties = DistributedScheduleUtils.getProperties();
        boolean distributedScheduleEnable = distributedScheduleProperties.isEnabled();
        boolean isMaster = DistributedScheduleUtils.isMaster();
        boolean isWorker = DistributedScheduleUtils.isWorker();
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] isAp: " + (distributedScheduleEnable && !isMaster && !isWorker)));
        return distributedScheduleEnable && !isMaster && !isWorker;
    }

    public static boolean isRedirectDwsys() {
        boolean isAp = DistributedScheduleUtils.isAp();
        boolean isHigherMaster = DistributedScheduleUtils.isHigherMaster();
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] isRedirectDwsys: " + (isAp || isHigherMaster)));
        return isAp || isHigherMaster;
    }

    public static boolean isRedirectSchedule() {
        boolean isSimpleMaster = DistributedScheduleUtils.isSimpleMaster();
        boolean isWorker = DistributedScheduleUtils.isWorker();
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] isRedirectSchedule: " + (isSimpleMaster || isWorker)));
        return isSimpleMaster || isWorker;
    }

    public static boolean isExecuteWorkerByHashMod(String key) {
        int serialNumber;
        int totalWorker = DistributedScheduleUtils.getOnlineWorker();
        int dwHash = DistributedScheduleUtils.getDWHash(key);
        int toWorker = dwHash % totalWorker;
        boolean isExecuteWorker = toWorker == (serialNumber = DistributedScheduleUtils.getSerialNumber());
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] totalWorker: " + totalWorker));
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] dwHash: " + dwHash));
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] toWorker: " + toWorker));
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] serialNumber: " + serialNumber));
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] isExecuteWorker: " + (toWorker == serialNumber)));
        return isExecuteWorker;
    }

    public static boolean isExecuteWorker(Trigger trigger) {
        String scheduleId = trigger.getKey().getGroup();
        String executeWorkerId = Optional.ofNullable(DWQuartz.redisTemplate.opsForHash().get((Object)redisScheduleExecutors, (Object)scheduleId)).orElse("").toString();
        if (DistributedScheduleUtils.isExecuteWorkerByRedisConfig(scheduleId)) {
            trigger.getJobDataMap().put("is_substitute_executor", false);
            return true;
        }
        if (onlineWorkers.get(executeWorkerId) == null) {
            if (DistributedScheduleUtils.isExecuteWorkerByHashMod(scheduleId)) {
                trigger.getJobDataMap().put("is_substitute_executor", true);
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isExecuteWorkerByRedisConfig(String scheduleId) {
        String executeWorkerId;
        String workerId = DistributedScheduleUtils.getWorkerId();
        return workerId.equals(executeWorkerId = Optional.ofNullable(DWQuartz.redisTemplate.opsForHash().get((Object)redisScheduleExecutors, (Object)scheduleId)).orElse("").toString());
    }

    public static int getDWHash(String key) {
        int sumOfdigits = DistributedScheduleUtils.sumOfdigits(String.valueOf(key.hashCode()));
        int dwHash = sumOfdigits + 3000;
        return dwHash;
    }

    private static int sumOfdigits(String number) {
        int sum = 0;
        for (int i = 0; i < number.length(); ++i) {
            char ch = number.charAt(i);
            if (!Character.isDigit(ch)) continue;
            int n = Character.getNumericValue(ch);
            sum += n;
        }
        return sum;
    }

    public static int getOnlineWorker() {
        return onlineWorkers.size();
    }

    public static List<String> getAllWorkerIds() {
        List<DWDistributedScheduleWorkersProperties.DWDistributedScheduleWorkerProperties> workers = DWScheduleDistributeWorkerConfigService.getInstance().getWorkersProperties().getWorker();
        if (CollectionUtils.isNotEmpty(workers)) {
            return workers.stream().map(DWDistributedScheduleWorkersProperties.DWDistributedScheduleWorkerProperties::getWorkName).collect(Collectors.toList());
        }
        throw new RuntimeException("no worker configured!");
    }

    public static int getSerialNumber() {
        String targetWorkerId = DistributedScheduleUtils.getWorkerId();
        ArrayList tmp = new ArrayList(onlineWorkers.keySet());
        tmp.sort(new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        for (int j = 0; j < tmp.size(); ++j) {
            if (!tmp.get(j).toString().equals(targetWorkerId)) continue;
            return j;
        }
        log.debug((Object)"[DWSchedule.DistributedScheduleUtils] no targetWorkerId or distributedScheduleWorkerUrl default 0");
        return 0;
    }

    public static String getWorkerId() {
        return redisWorkerKeyPrefix + workerProperties.getWorkName();
    }

    public static Object redirectDwsysAsAp(String methodName) throws Exception {
        log.info((Object)("[DWSchedule.DistributedScheduleUtils] " + methodName + ": redirectDwsysAsAp"));
        DWDistributedScheduleProperties distributedScheduleProperties = DistributedScheduleUtils.getProperties();
        String url = distributedScheduleProperties.getMasterUrl();
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new DWBusinessException("no distributedScheduleMasterUrl");
        }
        url = url + "/restful/service/DWSys/IScheduleService/" + methodName;
        CloseableHttpResponse httpResponse = DistributedScheduleUtils.redirect(url);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        HttpEntity httpEntity = httpResponse.getEntity();
        String responseBody = EntityUtils.toString((HttpEntity)httpEntity, (Charset)StandardCharsets.UTF_8);
        Map responseMap = new HashMap();
        try {
            Gson gson = DWGsonProvider.getGson();
            responseMap = (Map)gson.fromJson(responseBody, Map.class);
        }
        catch (Exception e) {
            log.error((Object)("[DWSchedule.DistributedScheduleUtils] response body: " + responseBody));
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            String message = ExceptionUtils.getMessage((Throwable)rootCause);
            String stackTrace = ExceptionUtils.getStackTrace((Throwable)rootCause);
            log.error((Object)("[DWSchedule.DistributedScheduleUtils] message: " + message));
            log.error((Object)("[DWSchedule.DistributedScheduleUtils] stack trace: " + stackTrace));
            throw new DWException("response body: " + responseBody, (Throwable)e);
        }
        if (statusCode == 200) {
            long duration = Double.valueOf(String.valueOf(responseMap.getOrDefault("duration", 0))).longValue();
            DWServiceContext.getContext().pushDuration(duration);
            Object response = responseMap.get("response");
            return response;
        }
        DistributedScheduleException exception = new DistributedScheduleException();
        Map debugInfoMap = responseMap.getOrDefault("debugInfo", new HashMap());
        String stackTrace = debugInfoMap.getOrDefault("stackTrace", "");
        exception.setStatusCode(statusCode);
        exception.setRemoteStackTrace(stackTrace);
        exception.setSourceId("Master");
        throw exception;
    }

    public static Map<String, Map> redirectDwsysAsHigherMaster(String methodName) throws Exception {
        log.info((Object)("[DWSchedule.DistributedScheduleUtils] " + methodName + ": redirectDwsysAsHigherMaster"));
        DWDistributedScheduleProperties distributedScheduleProperties = DistributedScheduleUtils.getProperties();
        String distributedScheduleWorkerUrl = distributedScheduleProperties.getWorkerUrl();
        if (StringUtils.isBlank((CharSequence)distributedScheduleWorkerUrl)) {
            throw new DWBusinessException("no distributedScheduleWorkerUrl");
        }
        List<String> mappingList = Arrays.asList(distributedScheduleWorkerUrl.split(","));
        for (String string : mappingList) {
            String[] mappingParts = string.split("::");
            if (mappingParts.length != 2) {
                throw new DWBusinessException("check distributedScheduleWorkerUrl pattern");
            }
            String targetWorkerId = mappingParts[0];
            String targetUrl = mappingParts[1];
            if (StringUtils.isBlank((CharSequence)targetWorkerId)) {
                throw new DWBusinessException("check distributedScheduleWorkerUrl WorkerId");
            }
            if (!StringUtils.isBlank((CharSequence)targetUrl)) continue;
            throw new DWBusinessException("check distributedScheduleWorkerUrl " + targetWorkerId + " url");
        }
        final ArrayBlockingQueue responseQueue = new ArrayBlockingQueue(mappingList.size());
        for (String mapping : mappingList) {
            String[] mappingParts = mapping.split("::");
            final String targetWorkerId = mappingParts[0];
            String targetUrl = mappingParts[1];
            final String url = targetUrl = targetUrl + "/restful/service/DWSys/IScheduleService/" + methodName;
            final DWServiceContext finalContext = DWServiceContext.getContext();
            Executors.newSingleThreadExecutor().submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    DWServiceContext.setContext((DWServiceContext)finalContext);
                    try {
                        CloseableHttpResponse httpResponse = DistributedScheduleUtils.redirect(url);
                        HttpEntity httpEntity = httpResponse.getEntity();
                        String responseBody = EntityUtils.toString((HttpEntity)httpEntity, (Charset)StandardCharsets.UTF_8);
                        Map responseBodyMap = new HashMap();
                        Gson gson = DWGsonProvider.getGson();
                        responseBodyMap = (Map)gson.fromJson(responseBody, Map.class);
                        WorkerResponseWrapper workerResponseWrapper = new WorkerResponseWrapper(targetWorkerId, responseBodyMap);
                        responseQueue.add(workerResponseWrapper);
                    }
                    catch (Throwable e) {
                        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                        String message = ExceptionUtils.getMessage((Throwable)rootCause);
                        String stackTrace = ExceptionUtils.getStackTrace((Throwable)rootCause);
                        log.error((Object)("[DWSchedule.DistributedScheduleUtils] message: " + message));
                        log.error((Object)("[DWSchedule.DistributedScheduleUtils] stack trace: " + stackTrace));
                        HashMap<String, String> responseBodyMap = new HashMap<String, String>();
                        responseBodyMap.put("response", stackTrace);
                        WorkerResponseWrapper workerResponseWrapper = new WorkerResponseWrapper(targetWorkerId, responseBodyMap);
                        responseQueue.add(workerResponseWrapper);
                        return false;
                    }
                    return true;
                }
            });
        }
        while (responseQueue.remainingCapacity() != 0) {
        }
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        responseQueue.forEach(workerResponseWrapper -> {
            String workerId = ((WorkerResponseWrapper)workerResponseWrapper).getWorkerId();
            Map response = ((WorkerResponseWrapper)workerResponseWrapper).getResponse();
            workerResponseMap.put(workerId, response);
        });
        return hashMap;
    }

    public static Map recoverWorkerData(String workerId, String body) throws Exception {
        String targetUrl;
        String targetWorkerId;
        String[] mappingParts;
        String distributedScheduleWorkerUrl = DistributedScheduleUtils.getProperties().getWorkerUrl();
        if (StringUtils.isBlank((CharSequence)distributedScheduleWorkerUrl)) {
            throw new DWBusinessException("no distributedScheduleWorkerUrl");
        }
        List<String> mappingList = Arrays.asList(distributedScheduleWorkerUrl.split(","));
        for (String mapping : mappingList) {
            mappingParts = mapping.split("::");
            if (mappingParts.length != 2) {
                throw new DWBusinessException("check distributedScheduleWorkerUrl pattern");
            }
            targetWorkerId = mappingParts[0];
            targetUrl = mappingParts[1];
            if (StringUtils.isBlank((CharSequence)targetWorkerId)) {
                throw new DWBusinessException("check distributedScheduleWorkerUrl WorkerId");
            }
            if (!StringUtils.isBlank((CharSequence)targetUrl)) continue;
            throw new DWBusinessException("check distributedScheduleWorkerUrl " + targetWorkerId + " url");
        }
        for (String mapping : mappingList) {
            mappingParts = mapping.split("::");
            targetWorkerId = mappingParts[0];
            if (!targetWorkerId.equals(workerId)) continue;
            targetUrl = mappingParts[1];
            targetUrl = targetUrl + "/restful/service/DWSys/IScheduleService/recoverWorkerData";
            CloseableHttpResponse httpResponse = DistributedScheduleUtils.redirect(targetUrl, body);
            HttpEntity httpEntity = httpResponse.getEntity();
            String responseBody = EntityUtils.toString((HttpEntity)httpEntity, (Charset)StandardCharsets.UTF_8);
            Map responseMap = new HashMap();
            try {
                Gson gson = DWGsonProvider.getGson();
                responseMap = (Map)gson.fromJson(responseBody, Map.class);
            }
            catch (Exception e) {
                log.error((Object)("[DWSchedule.DistributedScheduleUtils] response body: " + responseBody));
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                String message = ExceptionUtils.getMessage((Throwable)rootCause);
                String stackTrace = ExceptionUtils.getStackTrace((Throwable)rootCause);
                log.error((Object)("[DWSchedule.DistributedScheduleUtils] message: " + message));
                log.error((Object)("[DWSchedule.DistributedScheduleUtils] stack trace: " + stackTrace));
                throw new DWException("response body: " + responseBody, (Throwable)e);
            }
            return responseMap;
        }
        throw new DWException("no " + workerId);
    }

    private static CloseableHttpResponse redirect(String url) throws Exception {
        String body = DWServiceContext.getContext().getRequestBody();
        CloseableHttpResponse httpResponse = DistributedScheduleUtils.redirect(url, body);
        return httpResponse;
    }

    private static CloseableHttpResponse redirect(String url, String body) throws Exception {
        CloseableHttpClient httpclient = DWScheduleHttpClient.get();
        String token = DWServiceContext.getContext().getToken();
        String tenantId = (String)DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIamTenantIdKey());
        StringEntity stringEntity = new StringEntity(body, StandardCharsets.UTF_8);
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)stringEntity);
        httpPost.addHeader("token", token);
        httpPost.addHeader("routerKey", tenantId);
        long threadId = Thread.currentThread().getId();
        log.info((Object)String.format("[DWSchedule.DistributedScheduleUtils]>redirect request{%s}>routerKey=%s, url=%s", threadId, tenantId, url));
        log.debug((Object)String.format("[DWSchedule.DistributedScheduleUtils]>redirect request{%s}>body=%s", threadId, body));
        CloseableHttpResponse httpResponse = httpclient.execute((HttpUriRequest)httpPost);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        log.info((Object)String.format("[DWSchedule.DistributedScheduleUtils]>redirect result{%s}>status=%s", threadId, statusCode));
        return httpResponse;
    }

    public static void refreshStoppedSchedule() throws Exception {
        log.info((Object)"==================refreshStoppedSchedule================");
        Field field0 = DWQuartz.class.getDeclaredField("scheduler");
        field0.setAccessible(true);
        DWStdScheduler dwStdScheduler = (DWStdScheduler)((Object)field0.get(DWQuartz.getInstance()));
        Field field1 = DWStdScheduler.class.getDeclaredField("sched");
        field1.setAccessible(true);
        DWQuartzScheduler dwQuartzScheduler = (DWQuartzScheduler)((Object)field1.get((Object)dwStdScheduler));
        Field field2 = DWQuartzScheduler.class.getSuperclass().getDeclaredField("resources");
        field2.setAccessible(true);
        QuartzSchedulerResources resources = null;
        resources = (QuartzSchedulerResources)field2.get((Object)dwQuartzScheduler);
        DWJobStore jobStore = (DWJobStore)resources.getJobStore();
        Field field3 = DWJobStore.class.getSuperclass().getSuperclass().getDeclaredField("firstCheckIn");
        field3.setAccessible(true);
        field3.set((Object)jobStore, true);
        Field field4 = DWJobStore.class.getSuperclass().getSuperclass().getDeclaredField("misfireHandler");
        field4.setAccessible(true);
        Class<?> misfireHandler = field4.get((Object)jobStore).getClass();
        Method method = misfireHandler.getDeclaredMethod("manage", new Class[0]);
        method.setAccessible(true);
        method.invoke(field4.get((Object)jobStore), null);
    }

    public static boolean isHot(String type, String cron, DWScheduleQuartzInfo quartzInfo) {
        boolean isHot = false;
        switch (type) {
            case "cron": {
                String[] minuteIntervalAttr;
                if (!StringUtils.isNotEmpty((CharSequence)cron)) break;
                String secondCron = cron.split(" ")[0];
                String minuteCron = cron.split(" ")[1];
                if (secondCron.split("/").length > 1) {
                    isHot = Integer.valueOf(secondCron.split("/")[1]) <= 60;
                    break;
                }
                if (minuteCron.split("/").length > 1) {
                    isHot = Integer.valueOf(minuteCron.split("/")[1]) <= 1;
                    break;
                }
                String[] minutCronArr = minuteCron.split("/");
                if (!minutCronArr[0].matches("^([0-9],{0,1})+") || (minuteIntervalAttr = minutCronArr[0].split(",")).length <= 1) break;
                isHot = Integer.valueOf(minuteIntervalAttr[1]) - Integer.valueOf(minuteIntervalAttr[0]) <= 1;
                break;
            }
            case "frequency": {
                int frequency = quartzInfo.getDetail().getFrequency();
                if (1 != quartzInfo.getDetail().getRepeatType() || frequency > 1) break;
                isHot = true;
                break;
            }
        }
        return isHot;
    }

    public static void assignHotScheduleExecuteWorker(DWScheduleQuartzInfo quartzInfo) {
        if (DistributedScheduleUtils.isMaster()) {
            String executeWorker = DWQuartz.redisTemplate.opsForList().leftPop((Object)redisSubscribeWorkers).toString();
            DWQuartz.redisTemplate.opsForList().rightPush((Object)redisSubscribeWorkers, (Object)executeWorker);
            DWQuartz.redisTemplate.opsForHash().put((Object)redisScheduleExecutors, (Object)quartzInfo.getScheduleId(), (Object)executeWorker);
        }
    }

    public static void assertHaveNoOfflineWorkers() {
        ArrayList wokerIds = new ArrayList();
        onlineWorkers.forEach((key, value) -> {
            String wokerId = key.toString().substring(redisWorkerKeyPrefix.length());
            wokerIds.add(wokerId);
        });
        List offlineWorkerIds = DistributedScheduleUtils.getAllWorkerIds().stream().filter(id -> !wokerIds.contains(id)).collect(Collectors.toList());
        if (offlineWorkerIds.size() > 0) {
            throw new RuntimeException(String.join((CharSequence)",", offlineWorkerIds) + " is offline !");
        }
    }

    public static void updateRedisRecord(Trigger trigger) {
        HashMap<String, Long> triggerRecord = new HashMap<String, Long>();
        triggerRecord.put("NEXT_FIRE_TIME", trigger.getNextFireTime().getTime());
        triggerRecord.put("PREV_FIRE_TIME", trigger.getPreviousFireTime() == null ? -1L : trigger.getPreviousFireTime().getTime());
        DWQuartz.redisTemplate.opsForHash().put((Object)redisScheduleTriggerRecords, (Object)trigger.getKey().getGroup(), triggerRecord);
    }

    private static class WorkerResponseWrapper {
        private String workerId;
        private Map response;

        private WorkerResponseWrapper(String workerId, Map response) {
            this.workerId = workerId;
            this.response = response;
        }

        private String getWorkerId() {
            return this.workerId;
        }

        private Map getResponse() {
            return this.response;
        }
    }
}

