/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.quartz.job;

import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.schedule.DWScheduleProperties;
import com.digiwin.app.schedule.entity.DWJobResult;
import com.digiwin.app.schedule.util.DWScheduleExceptionUtils;
import com.digiwin.app.schedule.util.DWScheduleServiceContextUtil;
import com.digiwin.app.schedule.util.DistributedScheduleUtils;
import com.digiwin.app.service.DWServiceChainContext;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.utils.DWServiceChainUtils;
import com.digiwin.gateway.filter.DWInnerInvocationUtils;
import com.digiwin.iam.HttpRequestModel;
import com.digiwin.iam.HttpRequester;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMHttpRequester;
import com.digiwin.utils.DWTenantUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

public class DWJobInvoker
implements Job,
InterruptableJob {
    private static Log log = LogFactory.getLog(DWJobInvoker.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        boolean isExclude;
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        if (DistributedScheduleUtils.isWorker()) {
            if (!DistributedScheduleUtils.isExecuteWorker(context.getTrigger())) {
                jobDataMap.put("not_executor", true);
                return;
            }
            jobDataMap.put("not_executor", false);
        }
        if (isExclude = jobDataMap.getBoolean("isExclude")) {
            return;
        }
        String moduleName = jobDataMap.getString("module_name");
        String serviceName = jobDataMap.getString("job_name");
        Map paramMap = (Map)jobDataMap.get((Object)"schedule_param");
        if (StringUtils.isEmpty((CharSequence)moduleName) || StringUtils.isEmpty((CharSequence)serviceName)) {
            throw new JobExecutionException("\u8a2d\u5b9a\u7570\u5e38");
        }
        Map<String, Object> profile = DWScheduleServiceContextUtil.initProfile(jobDataMap);
        int retryTimes = DWScheduleProperties.getDefaultProperties().getDistributedScheduleProperties().getScheduleRetryTimes();
        do {
            if (retryTimes != DWScheduleProperties.getDefaultProperties().getDistributedScheduleProperties().getScheduleRetryTimes()) {
                log.debug((Object)String.format("\u958b\u59cb\u7b2c" + (DWScheduleProperties.getDefaultProperties().getDistributedScheduleProperties().getScheduleRetryTimes() - retryTimes) + "\u6b21\u91cd\u8a66", new Object[0]));
            }
            DWJobResult result = new DWJobResult();
            try {
                DWDefaultParameters parameters;
                DWScheduleProperties scheduleProperties = DWScheduleProperties.getDefaultProperties();
                if (DWServiceChainUtils.isServiceChainEnabled()) {
                    DWServiceChainContext.getContext().clear();
                }
                if (DistributedScheduleUtils.isRedirectSchedule()) {
                    parameters = new HashMap();
                    parameters.put("paramMap", paramMap);
                    result = this.outerInvoke(moduleName, serviceName, "executeJob", (Map<String, Object>)parameters, profile);
                } else {
                    if (scheduleProperties.isRemoteInvocation()) {
                        parameters = new HashMap();
                        parameters.put("paramMap", paramMap);
                        result = this.innerInvoke(moduleName, serviceName, "executeJob", (Map<String, Object>)parameters, profile);
                    } else {
                        if (DWServiceChainUtils.isServiceChainEnabled()) {
                            DWServiceChainUtils.initContext(null);
                        }
                        parameters = new DWDefaultParameters();
                        parameters.put("paramMap", (Object)paramMap);
                        DWContainerContext containerContext = DWContainerContext.getInstance();
                        result = (DWJobResult)containerContext.invoke(moduleName, serviceName, "executeJob", (DWParameters)parameters, profile);
                    }
                    jobDataMap.put("execute_status", result == null ? "" : result.getExecuteStatus());
                    jobDataMap.put("message", result == null ? "" : result.getMessage());
                    jobDataMap.put("message_detail", result == null ? "" : result.getMessageDetail());
                }
                if ("completed".equals(result.getExecuteStatus())) break;
                if (--retryTimes < 0) continue;
                try {
                    Thread.sleep(DWScheduleProperties.getDefaultProperties().getDistributedScheduleProperties().getScheduleRetrySleepSeconds() * 1000);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                Throwable actualException = this.getCause(e);
                String exeErrorDetailMsg = DWScheduleExceptionUtils.getStackTrace(actualException);
                jobDataMap.put("execute_status", "error");
                jobDataMap.put("message", actualException.getMessage());
                jobDataMap.put("message_detail", exeErrorDetailMsg);
                if (--retryTimes < 0) continue;
                try {
                    Thread.sleep(DWScheduleProperties.getDefaultProperties().getDistributedScheduleProperties().getScheduleRetrySleepSeconds() * 1000);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        } while (retryTimes >= 0);
    }

    private DWJobResult innerInvoke(String moduleName, String serviceName, String methodName, Map<String, Object> parameters, Map<String, Object> profile) throws Exception {
        HttpResponseModel responseModel = DWInnerInvocationUtils.innerInvoke((String)moduleName, (String)serviceName, (String)methodName, parameters, profile);
        int httpStatusCode = responseModel.getHttpStatusCode();
        if (httpStatusCode != 200) {
            DWInnerInvokeResponseFailedException ex = new DWInnerInvokeResponseFailedException(responseModel.getResponseBody(), httpStatusCode);
            ex.setStatusCode(httpStatusCode);
            throw ex;
        }
        return this.postInvoke(responseModel);
    }

    private DWJobResult outerInvoke(String moduleName, String serviceName, String methodName, Map<String, Object> parameters, Map<String, Object> profile) throws Exception {
        HttpRequestModel requestModel = IAMHttpRequester.getHttpRequestModel();
        String requestBody = DWGsonProvider.getGson().toJson(parameters);
        requestModel.setRequestBody(requestBody);
        HashMap<String, String> header = new HashMap<String, String>();
        String tenantId = (String)profile.get(DWTenantUtils.getIamTenantIdKey());
        String innerToken = DWInnerInvocationUtils.getInnerToken(profile);
        header.put(DWInnerInvocationUtils.HEADER_KEY_INNER_TOKEN, innerToken);
        header.put("Content-Type", "application/json;charset=UTF-8");
        header.put("routerKey", tenantId);
        requestModel.setRequestHeader(header);
        DWScheduleProperties scheduleProperties = DWScheduleProperties.getDefaultProperties();
        String distributedScheduleTargetUrl = scheduleProperties.getDistributedScheduleProperties().getTargetJobAppUrl();
        if (StringUtils.isBlank((CharSequence)distributedScheduleTargetUrl)) {
            throw new JobExecutionException("no distributedScheduleTargetUrl");
        }
        List<String> mappingList = Arrays.asList(distributedScheduleTargetUrl.split(","));
        for (String mapping : mappingList) {
            String[] mappingParts = mapping.split("::");
            if (mappingParts.length != 2) {
                throw new JobExecutionException("check distributedScheduleTargetUrl pattern");
            }
            String targetModuleName = mappingParts[0];
            String targetUrl = mappingParts[1];
            if (StringUtils.isBlank((CharSequence)targetModuleName)) {
                throw new JobExecutionException("check distributedScheduleTargetUrl module");
            }
            if (StringUtils.isBlank((CharSequence)targetUrl)) {
                throw new JobExecutionException("check distributedScheduleTargetUrl " + targetModuleName + " url");
            }
            if (!targetModuleName.equals(moduleName)) continue;
            String url = String.format("%s/restful/service/%s/%s/%s", targetUrl, moduleName, serviceName, methodName);
            requestModel.setUrl(url);
            requestModel.setRequestMethod(DWRequestMethod.POST);
            long threadId = Thread.currentThread().getId();
            log.info((Object)String.format("[DWJobInvoker]>outerInvoke invocation request{%s}>routerKey=%s, url=%s", threadId, tenantId, url));
            HttpResponseModel responseModel = HttpRequester.submitRequest((HttpRequestModel)requestModel);
            log.info((Object)String.format("[DWJobInvoker]>outerInvoke invocation result{%s}>status=%s", threadId, responseModel.getHttpStatusCode()));
            int httpStatusCode = responseModel.getHttpStatusCode();
            if (httpStatusCode != 200) {
                DWOuterInvokeResponseFailedException ex = new DWOuterInvokeResponseFailedException(responseModel.getResponseBody(), httpStatusCode);
                ex.setStatusCode(httpStatusCode);
                throw ex;
            }
            return this.postInvoke(responseModel);
        }
        throw new JobExecutionException("no distributedScheduleTargetUrl " + moduleName + " url");
    }

    private DWJobResult postInvoke(HttpResponseModel responseModel) throws Exception {
        DWJobResult result = null;
        String responseBody = responseModel.getResponseBody();
        DWJobInnerInvocationResult invocationResult = (DWJobInnerInvocationResult)DWInnerInvocationUtils.getGson().fromJson(responseBody, DWJobInnerInvocationResult.class);
        result = invocationResult.getResponse();
        return result;
    }

    public void interrupt() throws UnableToInterruptJobException {
    }

    private Throwable getCause(Throwable e) {
        Throwable cause = null;
        Throwable result = e;
        while (null != (cause = result.getCause()) && result != cause) {
            result = cause;
        }
        return result;
    }

    private class DWJobInnerInvocationResult {
        private DWJobResult response;

        private DWJobInnerInvocationResult() {
        }

        public DWJobResult getResponse() {
            return this.response;
        }
    }

    private abstract class InvokeResponseFailedException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private int statusCode;

        private InvokeResponseFailedException(String message, int statusCode) {
            super(message);
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }
    }

    private class DWOuterInvokeResponseFailedException
    extends InvokeResponseFailedException {
        private static final long serialVersionUID = 1L;

        private DWOuterInvokeResponseFailedException(String message, int statusCode) {
            super(message, statusCode);
        }
    }

    private class DWInnerInvokeResponseFailedException
    extends InvokeResponseFailedException {
        private static final long serialVersionUID = 1L;

        private DWInnerInvokeResponseFailedException(String message, int statusCode) {
            super(message, statusCode);
        }
    }
}

