/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import biweekly.util.DayOfWeek;
import biweekly.util.Frequency;
import biweekly.util.Recurrence;
import org.quartz.DateBuilder;
import org.quartz.RecurrenceRuleTrigger;
import org.quartz.RecurrenceRuleUtils;
import org.quartz.ScheduleBuilder;
import org.quartz.impl.triggers.RecurrenceRuleTriggerImpl;
import org.quartz.spi.MutableTrigger;

public class RecurrenceRuleScheduleBuilder
extends ScheduleBuilder<RecurrenceRuleTrigger> {
    private Recurrence recurrenceRule;
    private int misfireInstruction = 0;

    protected RecurrenceRuleScheduleBuilder(Recurrence rrule) {
        if (rrule == null) {
            throw new NullPointerException("recurrence rule cannot be null");
        }
        this.recurrenceRule = rrule;
    }

    protected MutableTrigger build() {
        RecurrenceRuleTriggerImpl ct = new RecurrenceRuleTriggerImpl();
        ct.setRecurrenceRule(this.recurrenceRule);
        ct.setMisfireInstruction(this.misfireInstruction);
        return ct;
    }

    public static RecurrenceRuleScheduleBuilder recurrenceRuleSchedule(String recurrenceRuleExpression) {
        return RecurrenceRuleScheduleBuilder.recurrenceRuleSchedule(RecurrenceRuleUtils.parseRecurrenceRuleExpression(recurrenceRuleExpression));
    }

    public static RecurrenceRuleScheduleBuilder recurrenceRuleSchedule(Recurrence rrule) {
        return new RecurrenceRuleScheduleBuilder(rrule);
    }

    public static RecurrenceRuleScheduleBuilder dailyAtHourAndMinute(int hour, int minute) {
        DateBuilder.validateHour((int)hour);
        DateBuilder.validateMinute((int)minute);
        String recurrenceRuleExpression = String.format("FREQ=DAILY;BYMINUTE=%d;BYHOUR=%d", minute, hour);
        return RecurrenceRuleScheduleBuilder.recurrenceRuleSchedule(recurrenceRuleExpression);
    }

    public static RecurrenceRuleScheduleBuilder atHourAndMinuteOnGivenDaysOfWeek(int hour, int minute, DayOfWeek ... daysOfWeek) {
        if (daysOfWeek == null || daysOfWeek.length == 0) {
            throw new IllegalArgumentException("You must specify at least one day of week.");
        }
        DateBuilder.validateHour((int)hour);
        DateBuilder.validateMinute((int)minute);
        return RecurrenceRuleScheduleBuilder.recurrenceRuleSchedule(new Recurrence.Builder(Frequency.DAILY).byDay(daysOfWeek).byHour(new Integer[]{hour}).byMinute(new Integer[]{minute}).build());
    }

    public static RecurrenceRuleScheduleBuilder weeklyOnDayAndHourAndMinute(DayOfWeek dayOfWeek, int hour, int minute) {
        DateBuilder.validateHour((int)hour);
        DateBuilder.validateMinute((int)minute);
        return RecurrenceRuleScheduleBuilder.recurrenceRuleSchedule(new Recurrence.Builder(Frequency.WEEKLY).byDay(new DayOfWeek[]{dayOfWeek}).byHour(new Integer[]{hour}).byMinute(new Integer[]{minute}).build());
    }

    public static RecurrenceRuleScheduleBuilder monthlyOnDayAndHourAndMinute(int dayOfMonth, int hour, int minute) {
        DateBuilder.validateDayOfMonth((int)dayOfMonth);
        DateBuilder.validateHour((int)hour);
        DateBuilder.validateMinute((int)minute);
        return RecurrenceRuleScheduleBuilder.recurrenceRuleSchedule(new Recurrence.Builder(Frequency.MONTHLY).byMonthDay(new Integer[]{dayOfMonth}).byHour(new Integer[]{hour}).byMinute(new Integer[]{minute}).build());
    }

    public RecurrenceRuleScheduleBuilder withMisfireHandlingInstructionIgnoreMisfires() {
        this.misfireInstruction = -1;
        return this;
    }

    public RecurrenceRuleScheduleBuilder withMisfireHandlingInstructionDoNothing() {
        this.misfireInstruction = 2;
        return this;
    }

    public RecurrenceRuleScheduleBuilder withMisfireHandlingInstructionFireAndProceed() {
        this.misfireInstruction = 1;
        return this;
    }
}

