/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql.transaction.seata.plugins.failurehandler;

import com.digiwin.app.sql.transaction.seata.plugins.DWSeataCache;
import com.digiwin.app.sql.transaction.seata.plugins.DWSeataPluginConstants;
import com.digiwin.app.sql.transaction.seata.plugins.DWSeataPluginException;
import com.digiwin.app.sql.transaction.seata.plugins.failurehandler.AlarmHandler;
import com.digiwin.app.sql.transaction.seata.plugins.failurehandler.UndoLogEntity;
import com.digiwin.http.client.DWHttpClient;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.core.compressor.CompressorFactory;
import io.seata.core.compressor.CompressorType;
import io.seata.tm.api.DefaultFailureHandlerImpl;
import io.seata.tm.api.GlobalTransaction;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DWSeataFailureHandlerImpl
extends DefaultFailureHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(DWSeataFailureHandlerImpl.class);
    private static final String SELECT_UNDO_LOG_SQL = "SELECT * FROM %s WHERE xid = ?";
    private static final String DELETE_UNDO_LOG_SQL = "DELETE FROM %s WHERE xid = ?";
    private static final String INSERT_UNDO_LOG_SQL = "INSERT INTO %s (`branch_id`,`xid`,`context`,`rollback_info`,`log_status`,`log_created`,`log_modified`) VALUES (?,?,?,?,?,?,?)";
    private DataSource dataSource;
    private Boolean cleanEnabled;
    private AlarmHandler alarmHandler;

    public DWSeataFailureHandlerImpl() {
    }

    public DWSeataFailureHandlerImpl(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DWSeataFailureHandlerImpl(DataSource dataSource, boolean cleanEnabled) {
        if (cleanEnabled && Objects.isNull(dataSource)) {
            throw new DWSeataPluginException("DataSource is null.");
        }
        this.dataSource = dataSource;
        this.cleanEnabled = cleanEnabled;
    }

    public void onCommitFailure(GlobalTransaction tx, Throwable cause) {
        super.onCommitFailure(tx, cause);
        if (this.getCleanEnabled().booleanValue()) {
            this.processUndoLog(tx);
        }
    }

    public void onRollbackFailure(GlobalTransaction tx, Throwable originalException) {
        super.onRollbackFailure(tx, originalException);
        if (this.getCleanEnabled().booleanValue()) {
            this.processUndoLog(tx);
        }
    }

    public void onBeginFailure(GlobalTransaction tx, Throwable cause) {
        super.onBeginFailure(tx, cause);
    }

    public void onRollbacking(GlobalTransaction tx, Throwable originalException) {
        super.onRollbacking(tx, originalException);
    }

    private void processUndoLog(GlobalTransaction tx) {
        String content;
        if (Objects.isNull(this.alarmHandler)) {
            this.initAlarmHandler();
        }
        if (StringUtils.isBlank((String)(content = this.cleanUndoLog(tx)))) {
            return;
        }
        this.sendWarnEmail(tx.getXid(), content);
    }

    private void initAlarmHandler() {
        Object alarmUrl = DWSeataCache.getGlobalConfig("alarmUrl");
        if (Objects.isNull(alarmUrl)) {
            throw new DWSeataPluginException("'alarmUrl' is null for operate undo log.");
        }
        Object iamUrl = DWSeataCache.getGlobalConfig("iamUrl");
        if (Objects.isNull(iamUrl)) {
            throw new DWSeataPluginException("'iamUrl' is null for operate undo log.");
        }
        String appId = "dap-seata-monitor";
        String tenantId = "99990000";
        this.alarmHandler = new AlarmHandler((String)alarmUrl, appId, (String)iamUrl, new DWHttpClient(), tenantId);
    }

    private String cleanUndoLog(GlobalTransaction tx) {
        ArrayList<Map<String, Object>> undoLogResults;
        if (Objects.isNull(this.getDataSource())) {
            throw new DWSeataPluginException("DataSource is null for operate undo log.");
        }
        String xid = tx.getXid();
        if (StringUtils.isBlank((String)xid)) {
            return "";
        }
        String undoLogTable = ConfigurationFactory.getInstance().getConfig("client.undo.logTable", "undo_log");
        List<UndoLogEntity> undoLogList = this.checkAndGetUndoLog(undoLogTable, xid, undoLogResults = new ArrayList<Map<String, Object>>());
        if (CollectionUtils.isEmpty(undoLogList)) {
            return "";
        }
        int rows = this.backupAndRemoveUndoLog(undoLogResults, undoLogTable, xid);
        if (rows != undoLogList.size()) {
            LOGGER.warn("Delete rows[size={}] and query rows[size={}] not matched when xid={}", new Object[]{rows, undoLogList.size(), xid});
        } else {
            LOGGER.info("Delete undo log success, xid={}, size={}, rows={}", new Object[]{xid, rows, undoLogList});
        }
        return undoLogList.toString();
    }

    private void sendWarnEmail(String xid, String msgContent) {
        String msg = String.format("seata\u5ba2\u6237\u7aef\u5168\u5c40\u4e8b\u52a1\u63d0\u4ea4\u6216\u56de\u6eda\u5931\u8d25, \u5df2\u81ea\u52a8\u5220\u9664undo log\u6570\u636e, \u5168\u5c40\u4e8b\u52a1ID\u5373xid=%s, \u6240\u6d89\u53ca\u7684undo log\u6570\u636e\u8bb0\u5f55=>%s", xid, msgContent);
        int count = 0;
        boolean rst = false;
        while (count < DWSeataPluginConstants.ALARM_RETRY_TIMES) {
            if (this.alarmHandler.sendAlarm(msg)) {
                rst = true;
                break;
            }
            ++count;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Sleep interrupted.", (Throwable)e);
            }
        }
        if (rst) {
            LOGGER.info("Send client alarm msg success, xid:{}", (Object)xid);
        } else {
            LOGGER.error("Retry times[{}] send client alarm msg failed, xid:{}", (Object)DWSeataPluginConstants.ALARM_RETRY_TIMES, (Object)xid);
        }
    }

    private List<UndoLogEntity> checkAndGetUndoLog(String undoLogTable, String xid, List<Map<String, Object>> undoLogResults) {
        String querySql = String.format(SELECT_UNDO_LOG_SQL, undoLogTable);
        Connection conn = null;
        PreparedStatement selectPst = null;
        ResultSet rs = null;
        try {
            conn = this.getDataSource().getConnection();
            selectPst = conn.prepareStatement(querySql);
            selectPst.setString(1, xid);
            rs = selectPst.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("Check undo log table error, table:{}, msg:{}", (Object)undoLogTable, (Object)e);
        }
        ArrayList<UndoLogEntity> undoLogList = new ArrayList<UndoLogEntity>();
        if (!Objects.isNull(rs)) {
            UndoLogEntity undoLogEntity = null;
            Map<String, Object> itemResult = null;
            try {
                while (rs.next()) {
                    undoLogEntity = this.populateUndoLogEntity(rs, xid);
                    undoLogList.add(undoLogEntity);
                    itemResult = this.populateUndoLogItem(rs);
                    undoLogResults.add(itemResult);
                }
            }
            catch (Exception e) {
                LOGGER.error("Parse undo log rs error, table:{}, msg:{}", (Object)undoLogTable, (Object)e);
            }
        }
        try {
            if (rs != null) {
                rs.close();
            }
            if (selectPst != null) {
                selectPst.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException closeEx) {
            LOGGER.error("Failed to close JDBC resource while check undo", (Throwable)closeEx);
        }
        return undoLogList;
    }

    private int backupAndRemoveUndoLog(List<Map<String, Object>> undoLogResults, String undoLogTable, String xid) {
        String deleteSql = String.format(DELETE_UNDO_LOG_SQL, undoLogTable);
        String insertSql = String.format(INSERT_UNDO_LOG_SQL, undoLogTable + "_backup");
        int rows = 0;
        try (Connection conn = this.getDataSource().getConnection();){
            try (PreparedStatement delPst = conn.prepareStatement(deleteSql);
                 PreparedStatement addPst = conn.prepareStatement(insertSql);){
                conn.setAutoCommit(false);
                this.saveUndoLogHistory(addPst, undoLogResults);
                delPst.setString(1, xid);
                rows = delPst.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                LOGGER.error("Execute 'backupAndRemoveUndoLog' error, table:{}, msg:{}", (Object)undoLogTable, (Object)e);
                try {
                    conn.rollback();
                }
                catch (SQLException ex) {
                    LOGGER.error("Rollback 'backupAndRemoveUndoLog' error, table:{}, msg:{}", (Object)undoLogTable, (Object)ex);
                }
            }
        }
        catch (SQLException sqlEx) {
            LOGGER.error("Get db connect error, table:{}, msg:{}", (Object)undoLogTable, (Object)sqlEx);
        }
        return rows;
    }

    private void saveUndoLogHistory(PreparedStatement pst, List<Map<String, Object>> undoLogResults) throws SQLException {
        for (Map<String, Object> undoLog : undoLogResults) {
            pst.setLong(1, (Long)undoLog.get("branch_id"));
            pst.setString(2, (String)undoLog.get("xid"));
            pst.setString(3, (String)undoLog.get("context"));
            pst.setBlob(4, (Blob)undoLog.get("rollback_info"));
            pst.setInt(5, (Integer)undoLog.get("log_status"));
            pst.setTimestamp(6, (Timestamp)undoLog.get("log_created"));
            pst.setTimestamp(7, (Timestamp)undoLog.get("log_modified"));
            pst.addBatch();
        }
        pst.executeBatch();
    }

    private UndoLogEntity populateUndoLogEntity(ResultSet rs, String xid) throws SQLException {
        UndoLogEntity undoLogEntity = new UndoLogEntity();
        undoLogEntity.setXid(xid);
        undoLogEntity.setBranchId(rs.getLong("branch_id"));
        undoLogEntity.setLogStatus(rs.getInt("log_status"));
        undoLogEntity.setLogCreated(rs.getTimestamp("log_created"));
        undoLogEntity.setLogModified(rs.getTimestamp("log_modified"));
        String contextStr = rs.getString("context");
        undoLogEntity.setContext(contextStr);
        byte[] rollbackInfo = this.getRollbackInfo(rs);
        if (!Objects.isNull(rollbackInfo)) {
            undoLogEntity.setRollbackInfo(new String(rollbackInfo, StandardCharsets.UTF_8));
        }
        return undoLogEntity;
    }

    private Map<String, Object> populateUndoLogItem(ResultSet rs) throws SQLException {
        HashMap<String, Object> itemResult = new HashMap<String, Object>();
        itemResult.put("xid", rs.getString("branch_id"));
        itemResult.put("branch_id", rs.getLong("branch_id"));
        itemResult.put("context", rs.getString("context"));
        itemResult.put("rollback_info", rs.getBlob("rollback_info"));
        itemResult.put("log_status", rs.getInt("log_status"));
        itemResult.put("log_created", rs.getTimestamp("log_created"));
        itemResult.put("log_modified", rs.getTimestamp("log_modified"));
        return itemResult;
    }

    private byte[] getRollbackInfo(ResultSet rs) throws SQLException {
        byte[] rollbackInfo = rs.getBytes("rollback_info");
        String rollbackInfoContext = rs.getString("context");
        Map context = CollectionUtils.decodeMap((String)rollbackInfoContext);
        CompressorType compressorType = CompressorType.getByName((String)context.getOrDefault("compressorType", CompressorType.NONE.name()));
        return CompressorFactory.getCompressor((byte)compressorType.getCode()).decompress(rollbackInfo);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setCleanEnabled(boolean cleanEnabled) {
        this.cleanEnabled = cleanEnabled;
    }

    public DataSource getDataSource() {
        if (!Objects.isNull(this.dataSource)) {
            return this.dataSource;
        }
        return DWSeataCache.getGlobalDataSource("seataUndoLogDataSource");
    }

    public Boolean getCleanEnabled() {
        if (!Objects.isNull(this.cleanEnabled)) {
            return this.cleanEnabled;
        }
        return DWSeataCache.isGlobalCleanEnabled();
    }
}

