/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql.transaction.seata.plugins.noticehandler;

import com.digiwin.app.sql.transaction.seata.plugins.noticehandler.DWSeataGlobalTransactionHolder;
import com.digiwin.app.sql.transaction.seata.plugins.noticehandler.GlobalTransactionEntity;
import io.seata.common.loader.LoadLevel;
import io.seata.core.context.ContextCore;
import io.seata.core.model.BranchType;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.springframework.util.StringUtils;

@LoadLevel(name="DWSeataThreadLocalContextCore", order=0x7FFFFFFF)
public class DWSeataThreadLocalContextCore
implements ContextCore {
    private ThreadLocal<Map<String, Object>> threadLocal = ThreadLocal.withInitial(HashMap::new);

    @Nullable
    public Object put(String key, Object value) {
        Map<String, Object> context = this.threadLocal.get();
        if (StringUtils.hasText((String)key) && !Objects.isNull(value)) {
            GlobalTransactionEntity entity;
            Object xidObj;
            if ("TX_XID".equals(key)) {
                String xid = value.toString();
                GlobalTransactionEntity entity2 = new GlobalTransactionEntity();
                entity2.setXid(xid);
                entity2.setBeginTime(new Timestamp(System.currentTimeMillis()));
                DWSeataGlobalTransactionHolder.getInstance().putIfAbsent(xid, entity2);
            } else if ("TX_BRANCH_TYPE".equals(key) && !Objects.isNull(xidObj = context.get("TX_XID")) && !Objects.isNull(entity = DWSeataGlobalTransactionHolder.getInstance().get(xidObj.toString()))) {
                entity.setBranchType(value == BranchType.AT ? "AT" : "XA");
            }
        }
        return context.put(key, value);
    }

    @Nullable
    public Object get(String key) {
        return this.threadLocal.get().get(key);
    }

    @Nullable
    public Object remove(String key) {
        Map<String, Object> context = this.threadLocal.get();
        if (StringUtils.hasText((String)key) && "TX_XID".equals(key)) {
            DWSeataGlobalTransactionHolder.getInstance().remove(key);
        }
        return context.remove(key);
    }

    public Map<String, Object> entries() {
        return this.threadLocal.get();
    }
}

