/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql.transaction.seata.saga.processor;

import com.digiwin.app.sql.transaction.seata.saga.processor.DWSeataSagaFactoryBean;
import java.util.Arrays;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;

public class DWSeataSagaClassPathScanner
extends ClassPathBeanDefinitionScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DWSeataSagaClassPathScanner.class);
    private ApplicationContext applicationContext;
    private Class<? extends DWSeataSagaFactoryBean> sagaFactoryBeanClass = DWSeataSagaFactoryBean.class;

    public DWSeataSagaClassPathScanner(BeanDefinitionRegistry registry, ApplicationContext applicationContext) {
        super(registry);
        this.applicationContext = applicationContext;
    }

    protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("No 'DWSeataSaga' was found in '{}' package. Please check your configuration.", (Object)Arrays.toString(basePackages));
            }
        } else {
            this.processBeanDefinitions(beanDefinitions);
        }
        return beanDefinitions;
    }

    protected boolean checkCandidate(String beanName, BeanDefinition beanDefinition) throws IllegalStateException {
        return super.checkCandidate(beanName, beanDefinition);
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }

    private void processBeanDefinitions(Set<BeanDefinitionHolder> beanDefinitions) {
        AbstractBeanDefinition definition = null;
        for (BeanDefinitionHolder holder : beanDefinitions) {
            definition = (AbstractBeanDefinition)holder.getBeanDefinition();
            String beanClassName = definition.getBeanClassName();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("Creating bean with name '%s' and '%s' sagaInterface", holder.getBeanName(), beanClassName));
            }
            definition.getConstructorArgumentValues().addGenericArgumentValue((Object)beanClassName);
            definition.setBeanClass(this.sagaFactoryBeanClass);
            definition.getPropertyValues().add("applicationContext", (Object)this.applicationContext);
            definition.setAutowireMode(2);
            definition.setScope("singleton");
        }
    }
}

