/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql.transaction.seata.tcc;

import com.digiwin.app.sql.transaction.seata.tcc.DWResultHolder;
import com.digiwin.app.sql.transaction.seata.tcc.DWSeataTccAction;
import com.digiwin.app.sql.transaction.seata.tcc.DWSeataTccException;
import com.digiwin.app.sql.transaction.seata.tcc.DWSeataTccParam;
import com.fasterxml.jackson.core.type.TypeReference;
import io.seata.common.util.JsonUtil;
import io.seata.rm.tcc.api.BusinessActionContext;
import io.seata.rm.tcc.api.BusinessActionContextUtil;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DWSeataAbstractTccAction<T>
implements DWSeataTccAction<T> {
    private static final Log LOGGER = LogFactory.getLog(DWSeataAbstractTccAction.class);

    @Override
    public void prepare(DWSeataTccParam<T> param) {
        BusinessActionContext actionContext = BusinessActionContextUtil.getContext();
        if (Objects.isNull(actionContext)) {
            throw new DWSeataTccException("TCC[" + this.getClass().getName() + "] prepare failed, because action context is null.");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("TCC[" + this.getClass().getName() + "] prepare phase: xid=" + actionContext.getXid()));
        }
        if (null == param) {
            param = new DWSeataTccParam();
        }
        param.setTxId(actionContext.getXid());
        param.setBranchId(String.valueOf(actionContext.getBranchId()));
        param.setActionName(actionContext.getActionName());
        boolean result = this.doPrepare(param);
        if (!result) {
            throw new DWSeataTccException("TCC[" + this.getClass().getName() + "] doPrepare failed, tccParam=" + param);
        }
        DWResultHolder.setResult(this.getClass(), actionContext.getXid(), "true");
    }

    @Override
    public void commit(BusinessActionContext actionContext) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("TCC[" + this.getClass().getName() + "] commit phase: xid=" + actionContext.getXid()));
        }
        if (!Objects.equals("true", DWResultHolder.getResult(this.getClass(), actionContext.getXid()))) {
            return;
        }
        DWSeataTccParam<T> param = this.convertParam(actionContext);
        boolean result = this.doCommit(param);
        if (!result) {
            throw new DWSeataTccException("TCC[" + this.getClass().getName() + "] doCommit failed, tccParam=" + param);
        }
        DWResultHolder.removeResult(this.getClass(), actionContext.getXid());
    }

    @Override
    public void rollback(BusinessActionContext actionContext) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("TCC[" + this.getClass().getName() + "] rollback phase: xid=" + actionContext.getXid()));
        }
        if (!Objects.equals("true", DWResultHolder.getResult(this.getClass(), actionContext.getXid()))) {
            return;
        }
        DWSeataTccParam<T> param = this.convertParam(actionContext);
        boolean result = this.doRollback(param);
        if (!result) {
            throw new DWSeataTccException("TCC[" + this.getClass().getName() + "] doRollback failed, tccParam=" + param);
        }
        DWResultHolder.removeResult(this.getClass(), actionContext.getXid());
    }

    private DWSeataTccParam<T> convertParam(BusinessActionContext actionContext) {
        DWSeataTccParam param = null;
        Object object = actionContext.getActionContext().get("tccParam");
        try {
            param = (DWSeataTccParam)JsonUtil.getJson().readValue(JsonUtil.getJson().writeValueAsString(object), new TypeReference<DWSeataTccParam<T>>(){});
        }
        catch (IOException e) {
            throw new DWSeataTccException("TCC[" + this.getClass().getName() + "] parse json failed.", e);
        }
        if (Objects.isNull(param)) {
            param = new DWSeataTccParam();
        }
        param.setTxId(actionContext.getXid());
        param.setBranchId(String.valueOf(actionContext.getBranchId()));
        param.setActionName(actionContext.getActionName());
        return param;
    }

    protected abstract boolean doPrepare(DWSeataTccParam<T> var1);

    protected abstract boolean doCommit(DWSeataTccParam<T> var1);

    protected abstract boolean doRollback(DWSeataTccParam<T> var1);
}

