/*
 * Decompiled with CFR 0.152.
 */
package io.seata.plugin.jackson.parser.mysql;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import io.seata.common.loader.LoadLevel;
import io.seata.rm.datasource.undo.parser.spi.JacksonSerializer;
import java.io.IOException;
import java.sql.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="mysqlTime")
public class MysqlTimeJacksonSerializer
implements JacksonSerializer<Time> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MysqlTimeJacksonSerializer.class);

    public Class<Time> type() {
        return Time.class;
    }

    public JsonSerializer<Time> ser() {
        return new JsonSerializer<Time>(){

            public void serializeWithType(Time time, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSerializer) throws IOException {
                WritableTypeId typeId = typeSerializer.writeTypePrefix(gen, typeSerializer.typeId((Object)time, JsonToken.VALUE_EMBEDDED_OBJECT));
                this.serialize(time, gen, serializers);
                gen.writeTypeSuffix(typeId);
            }

            public void serialize(Time time, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeString(String.valueOf(time.getTime()));
            }
        };
    }

    public JsonDeserializer<? extends Time> deser() {
        return new JsonDeserializer<Time>(){

            public Time deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                Time time = new Time(p.getValueAsLong());
                return time;
            }
        };
    }
}

