/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql.transaction.seata.aop;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.sql.transaction.seata.DWSeataConstants;
import com.digiwin.app.sql.transaction.seata.DWSeataUtils;
import com.digiwin.app.sql.transaction.seata.aop.DWSeataAbstractHttpInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.core.annotation.Order;

@Order(value=100011)
public class DWSeataCustomizeHttpRequestInterceptor
extends DWSeataAbstractHttpInterceptor<HttpUriRequest> {
    @Override
    protected void beforeInvoke(HttpUriRequest targetArgument) {
        String xid = DWSeataUtils.getDtxId();
        if (StringUtils.isNotBlank((CharSequence)xid)) {
            this.setDistributedTransactionInfo(targetArgument);
        }
    }

    protected void setDistributedTransactionInfo(HttpUriRequest targetArgument) {
        String xid = DWSeataUtils.getDtxId();
        if (StringUtils.isNotBlank((CharSequence)xid)) {
            targetArgument.addHeader("TX_XID", xid);
            DWServiceContext.getContext().set(DWSeataConstants.KEY_HEADER_DIGIWIN_GTXID, (Object)xid);
            targetArgument.addHeader(DWSeataConstants.KEY_HEADER_DIGIWIN_GTXID, xid);
            if (log.isDebugEnabled()) {
                log.debug("[DWSeataCustomizeHttpRequestInterceptor] http client add header key({}) value(){}", (Object)"TX_XID", (Object)xid);
                log.debug("[DWSeataCustomizeHttpRequestInterceptor] http client add header key({}) value(){}", (Object)DWSeataConstants.KEY_HEADER_DIGIWIN_GTXID, (Object)xid);
            }
        }
    }

    @Override
    protected void afterInvoke(Object result) {
    }
}

