/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql.transaction.seata.config;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.dao.properties.DWDaoDataSourceProperties;
import com.digiwin.app.dao.security.AESUtil;
import com.digiwin.app.sql.transaction.seata.DWSeataPropertyConfiguration;
import com.digiwin.app.sql.transaction.seata.aop.DWSeataCustomizeHttpRequestInterceptor;
import com.digiwin.app.sql.transaction.seata.filter.DWSeataContextFilter;
import com.digiwin.app.sql.transaction.seata.plugins.DWSeataCache;
import com.digiwin.app.sql.transaction.seata.plugins.failurehandler.DWSeataFailureHandlerImpl;
import com.digiwin.app.sql.transaction.seata.saga.DWSeataSagaDBStateMachineConfig;
import com.digiwin.app.sql.transaction.seata.saga.DWSeataSagaProcessCtrlStateMachineEngine;
import com.digiwin.app.sql.transaction.seata.saga.DWSeataSagaProperties;
import com.digiwin.app.sql.transaction.seata.saga.DWSeataSagaStateMachineEngineHolder;
import com.digiwin.app.sql.transaction.seata.saga.processor.DWSeataSagaBeanDefinitionRegistryPostProcessor;
import io.seata.rm.tcc.config.TCCFenceConfig;
import io.seata.spring.annotation.GlobalTransactionScanner;
import io.seata.spring.annotation.datasource.SeataAutoDataSourceProxyCreator;
import io.seata.tm.api.DefaultFailureHandlerImpl;
import io.seata.tm.api.FailureHandler;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.Filter;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.apache.commons.dbcp2.DWBasicDataSource;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(prefix="seata.", name={"enabled"}, havingValue="true", matchIfMissing=false)
public class DWDtxAutoConfiguration {
    private static final Log LOGGER = LogFactory.getLog(DWDtxAutoConfiguration.class);
    private static final String BEAN_DW_SEATAPROPERTY_CONFIGURATION = "dw-seata-property-configuration";
    private static final String BEAN_DW_GLOBALTRANSACTIONSCANNER = "dw-seata-globalTransactionScanner";
    private static final String BEAN_DW_TCC_FENCE_CONFIG = "dw-seata-tccFenceConfig";
    private static final String BEAN_DW_SAGA_PROPERTIES = "dw-seata-sagaProperties";
    private static final String BEAN_DW_SAGA_STATE_MACHINE_CONFIG = "dw-seata-sagaStateMachineConfig";
    private static final String BEAN_DW_SAGA_STATE_MACHINE_ENGINE = "dw-seata-sagaStateMachineEngine";
    private static final String BEAN_DW_SAGA_STATE_ENGINE_HOLDER = "dw-seata-sagaStateEngineHolder";
    private static final String BEAN_DW_SAGA_BEAN_POST_PROCESSOR = "dw-seata-sagaBeanDefinitionRegistryPostProcessor";
    private static final String BEAN_NAME_SEATA_AUTO_DATA_SOURCE_PROXY_CREATOR = "seataAutoDataSourceProxyCreator";
    private static final String SIMPLE_MODE_CLAZZ = "com.digiwin.app.event.simplified.DWSimplifiedApolloApplicationListener";
    public static final String BEAN_DW_SAGA_THREAD_EXECUTOR = "dw-seata-sagaThreadExecutor";
    public static final String BEAN_DW_DATASOURCE = "dw-dataSource";
    public static final String BEAN_DW_BASIC_DATASOURCE = "dw-basicDataSource";
    public static final String BEAN_DW_DATASOURCE_PROPERTIES = "dw-datasource-properties";
    private static final int ALLOW_ANONYMOUS_FILTER_ORDER = 100000;
    public static final int SEATA_CONTEXT_FILTER_ORDER = 100001;

    @Bean(value={"dw-seata-property-configuration"})
    @DependsOn(value={"dw-datasource-properties"})
    @ConditionalOnMissingBean(value={DWSeataPropertyConfiguration.class})
    public DWSeataPropertyConfiguration dwSeataPropertyConfiguration() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"[DWDtxAutoConfiguration] Seata: Automatically configure properties");
        }
        return new DWSeataPropertyConfiguration();
    }

    @Bean(name={"dw-basicDataSource"})
    @DependsOn(value={"dw-datasource-properties"})
    @ConditionalOnProperty(name={"seata.cleanUndoLog.enabled"}, havingValue="true", matchIfMissing=false)
    public DataSource dwBasicDataSource(@Qualifier(value="dw-datasource-properties") DWDaoDataSourceProperties dataSourceProperties) {
        boolean dbEnabled = false;
        if (StringUtils.hasText((String)DWApplicationConfigUtils.getProperty((String)"dbEnabled"))) {
            dbEnabled = Boolean.parseBoolean(DWApplicationConfigUtils.getProperty((String)"dbEnabled"));
        }
        if (dbEnabled && StringUtils.hasText((String)dataSourceProperties.getDbUrl())) {
            String driverClassName = dataSourceProperties.getJdbcDriverClassName();
            String dbUrl = dataSourceProperties.getDbUrl();
            String dbUsername = dataSourceProperties.getDbUsername();
            String dbPassword = dataSourceProperties.getDbPassword();
            String dbPasswordEncryptionKey = dataSourceProperties.getDbPasswordEncryptionKey();
            if (dbPasswordEncryptionKey != null && !"".equals(dbPasswordEncryptionKey.trim())) {
                dbPassword = AESUtil.decode((String)dbPassword, (String)dbPasswordEncryptionKey);
            }
            int dbConnectionInitialSize = dataSourceProperties.getDbConnectionInitialSize();
            int dbConnectionMinIdle = dataSourceProperties.getDbConnectionMinIdle();
            Integer dbConnectionMaxIdle = dataSourceProperties.getDbConnectionMaxIdle();
            int dbConnectionMaxTotal = dataSourceProperties.getDbConnectionMaxTotal();
            int dbConnectionMaxWaitMillis = dataSourceProperties.getDbConnectionMaxWaitMillis();
            DWBasicDataSource basicDataSource = new DWBasicDataSource();
            basicDataSource.setDriverClassName(driverClassName);
            basicDataSource.setUrl(dbUrl);
            basicDataSource.setUsername(dbUsername);
            basicDataSource.setPassword(dbPassword);
            basicDataSource.setInitialSize(dbConnectionInitialSize);
            basicDataSource.setMinIdle(dbConnectionMinIdle);
            if (dbConnectionMaxIdle != null) {
                basicDataSource.setMaxIdle(dbConnectionMaxIdle.intValue());
            } else {
                basicDataSource.setMaxIdle(dbConnectionMaxTotal);
            }
            basicDataSource.setMaxTotal(dbConnectionMaxTotal);
            basicDataSource.setMaxWaitMillis((long)dbConnectionMaxWaitMillis);
            return basicDataSource;
        }
        return null;
    }

    @Bean(value={"failureHandler"})
    @ConditionalOnMissingBean(value={FailureHandler.class})
    public FailureHandler failureHandler(@Qualifier(value="dw-basicDataSource") @Autowired(required=false) DataSource basicDataSource, @Qualifier(value="seataUndoLogDataSource") @Autowired(required=false) DataSource seataUndoLogDataSource) {
        boolean cleanEnabled = false;
        if (StringUtils.hasText((String)DWApplicationConfigUtils.getProperty((String)"seata.cleanUndoLog.enabled"))) {
            cleanEnabled = Boolean.parseBoolean(DWApplicationConfigUtils.getProperty((String)"seata.cleanUndoLog.enabled"));
        }
        DWSeataCache.setGlobalCleanEnabled((boolean)cleanEnabled);
        if (StringUtils.hasText((String)DWApplicationConfigUtils.getProperty((String)"appId"))) {
            DWSeataCache.putGlobalConfig((String)"appId", (Object)DWApplicationConfigUtils.getProperty((String)"appId"));
        }
        if (StringUtils.hasText((String)DWApplicationConfigUtils.getProperty((String)"alarmUrl"))) {
            DWSeataCache.putGlobalConfig((String)"alarmUrl", (Object)DWApplicationConfigUtils.getProperty((String)"alarmUrl"));
        }
        if (StringUtils.hasText((String)DWApplicationConfigUtils.getProperty((String)"iamUrl"))) {
            DWSeataCache.putGlobalConfig((String)"iamUrl", (Object)DWApplicationConfigUtils.getProperty((String)"iamUrl"));
        }
        DataSource globalDataSource = basicDataSource;
        if (!Objects.isNull(seataUndoLogDataSource)) {
            globalDataSource = seataUndoLogDataSource;
        }
        if (!Objects.isNull(globalDataSource)) {
            DWSeataCache.putGlobalDataSource((String)"seataUndoLogDataSource", (DataSource)globalDataSource);
        }
        if (cleanEnabled) {
            return new DWSeataFailureHandlerImpl();
        }
        return new DefaultFailureHandlerImpl();
    }

    @Bean(value={"dw-seata-globalTransactionScanner"})
    @DependsOn(value={"dw-seata-property-configuration", "failureHandler"})
    @ConditionalOnMissingBean(value={GlobalTransactionScanner.class})
    public GlobalTransactionScanner globalTransactionScanner(DWSeataPropertyConfiguration seataProperties, FailureHandler failureHandler) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"[DWDtxAutoConfiguration] Seata: Automatically configure bean GlobalTransactionScanner");
        }
        return new GlobalTransactionScanner(seataProperties.getApplicationId(), seataProperties.getTxServiceGroup(), failureHandler);
    }

    @Bean(value={"seataAutoDataSourceProxyCreator"})
    @DependsOn(value={"dw-seata-property-configuration"})
    @ConditionalOnMissingBean(value={SeataAutoDataSourceProxyCreator.class})
    @ConditionalOnExpression(value="!${seata.dynamicDatasource.enabled:false}")
    public SeataAutoDataSourceProxyCreator seataAutoDataSourceProxyCreator(DWSeataPropertyConfiguration seataProperties) {
        String[] excludesDsNames = new String[]{"org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy", "com.zaxxer.hikari.HikariDataSource"};
        if (!ArrayUtils.isEmpty((Object[])seataProperties.getExcludesForAutoProxying())) {
            excludesDsNames = seataProperties.getExcludesForAutoProxying();
        }
        return new SeataAutoDataSourceProxyCreator(seataProperties.isUseJdkProxy(), excludesDsNames, seataProperties.getDataSourceProxyMode());
    }

    @Bean(value={"dw-seata-context-filter"})
    public DWSeataContextFilter seataContextFilter() {
        return new DWSeataContextFilter();
    }

    @Bean(value={"dw-seata-context-filter-reg"})
    public FilterRegistrationBean<DWSeataContextFilter> seataContextFilterRegBean(@Qualifier(value="dw-seata-context-filter") DWSeataContextFilter seataContextFilter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)seataContextFilter);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setOrder(100001);
        return registration;
    }

    @Bean(value={"dw-seata-consumer-http-aop"})
    public DefaultPointcutAdvisor dwSeataConsumerHttpRequestAop() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("within(org.apache.http.client.HttpClient+) && execution(public org.apache.http.HttpResponse execute(org.apache.http.client.methods.HttpUriRequest))");
        DWSeataCustomizeHttpRequestInterceptor interceptor = new DWSeataCustomizeHttpRequestInterceptor();
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)interceptor);
        return advisor;
    }

    @Bean(value={"dw-seata-tccFenceConfig"})
    @ConditionalOnMissingBean(value={TCCFenceConfig.class})
    @ConditionalOnBean(value={DataSource.class})
    public TCCFenceConfig tccFenceConfig(@Qualifier(value="dw-dataSource") DataSource dataSource, PlatformTransactionManager transactionManager, @Qualifier(value="seataTccDataSource") @Autowired(required=false) DataSource tccDataSource, @Qualifier(value="seataTccTxManager") @Autowired(required=false) PlatformTransactionManager tccTransactionManager) {
        if (null != tccDataSource) {
            dataSource = tccDataSource;
        }
        if (null != tccTransactionManager) {
            transactionManager = tccTransactionManager;
        }
        return new TCCFenceConfig(dataSource, transactionManager);
    }

    @Configuration
    @ConditionalOnProperty(prefix="seata.", name={"saga.enabled"}, havingValue="true", matchIfMissing=false)
    public static class DWSeataSagaAutoConfiguration {
        @Bean(value={"dw-seata-sagaThreadExecutor"})
        public ThreadPoolExecutor threadExecutor() {
            ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
            executor.setCorePoolSize(2);
            executor.setMaxPoolSize(5);
            executor.setQueueCapacity(10000);
            executor.setThreadNamePrefix("SAGA_ASYNC_EXE_");
            executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
            executor.initialize();
            return executor.getThreadPoolExecutor();
        }

        @Bean(value={"dw-seata-sagaProperties"})
        @ConditionalOnClass(name={"com.digiwin.app.event.simplified.DWSimplifiedApolloApplicationListener"})
        @ConditionalOnMissingBean(value={DWSeataSagaProperties.class})
        public DWSeataSagaProperties dwSeataSagaProperties() {
            return new DWSeataSagaProperties();
        }

        @Bean(value={"dw-seata-sagaStateMachineConfig"})
        @ConditionalOnClass(name={"com.digiwin.app.event.simplified.DWSimplifiedApolloApplicationListener"})
        @DependsOn(value={"dw-seata-sagaThreadExecutor", "dw-seata-property-configuration"})
        @ConditionalOnMissingBean(value={DWSeataSagaDBStateMachineConfig.class})
        public DWSeataSagaDBStateMachineConfig dwSeataSagaDBStateMachineConfig(DWSeataPropertyConfiguration seataProperties, DWSeataSagaProperties seataSagaProperties) {
            DWSeataSagaDBStateMachineConfig dbStateMachineConfig = new DWSeataSagaDBStateMachineConfig();
            this.setSagaStateMachineConfig(seataProperties, seataSagaProperties, dbStateMachineConfig);
            return dbStateMachineConfig;
        }

        @Bean(value={"dw-seata-sagaStateMachineEngine"})
        @ConditionalOnClass(name={"com.digiwin.app.event.simplified.DWSimplifiedApolloApplicationListener"})
        @DependsOn(value={"dw-seata-sagaStateMachineConfig"})
        @ConditionalOnMissingBean(value={DWSeataSagaProcessCtrlStateMachineEngine.class})
        public DWSeataSagaProcessCtrlStateMachineEngine dwSeataSagaProcessCtrlStateMachineEngine() {
            return new DWSeataSagaProcessCtrlStateMachineEngine();
        }

        @Bean(value={"dw-seata-sagaStateEngineHolder"})
        @ConditionalOnClass(name={"com.digiwin.app.event.simplified.DWSimplifiedApolloApplicationListener"})
        @DependsOn(value={"dw-seata-sagaStateMachineEngine"})
        @ConditionalOnMissingBean(value={DWSeataSagaStateMachineEngineHolder.class})
        public DWSeataSagaStateMachineEngineHolder dwSeataSagaStateMachineEngineHolder() {
            return new DWSeataSagaStateMachineEngineHolder();
        }

        @Bean(value={"dw-seata-sagaBeanDefinitionRegistryPostProcessor"})
        @ConditionalOnClass(name={"com.digiwin.app.event.simplified.DWSimplifiedApolloApplicationListener"})
        @DependsOn(value={"dw-seata-sagaStateMachineEngine"})
        @ConditionalOnMissingBean(value={DWSeataSagaBeanDefinitionRegistryPostProcessor.class})
        public DWSeataSagaBeanDefinitionRegistryPostProcessor dwSeataSagaBeanDefinitionRegistryPostProcessor(DWSeataSagaProperties seataSagaProperties) {
            DWSeataSagaBeanDefinitionRegistryPostProcessor processor = new DWSeataSagaBeanDefinitionRegistryPostProcessor();
            if (StringUtils.hasText((String)seataSagaProperties.getBasePackage())) {
                processor.setBasePackage(seataSagaProperties.getBasePackage());
            }
            return processor;
        }

        private void setSagaStateMachineConfig(DWSeataPropertyConfiguration seataProperties, DWSeataSagaProperties seataSagaProperties, DWSeataSagaDBStateMachineConfig dbStateMachineConfig) {
            if (StringUtils.hasText((String)seataSagaProperties.getResources())) {
                dbStateMachineConfig.setResources(seataSagaProperties.getResources().split(","));
            }
            if (Objects.nonNull(seataSagaProperties.getEnableAsync())) {
                dbStateMachineConfig.setEnableAsync(seataSagaProperties.getEnableAsync());
            }
            if (Objects.nonNull(seataSagaProperties.getSagaBranchRegisterEnable())) {
                dbStateMachineConfig.setSagaBranchRegisterEnable(seataSagaProperties.getSagaBranchRegisterEnable());
            }
            if (Objects.nonNull(seataSagaProperties.getRmReportSuccessEnable())) {
                dbStateMachineConfig.setRmReportSuccessEnable(seataSagaProperties.getRmReportSuccessEnable());
            }
            if (Objects.nonNull(seataSagaProperties.getSagaRetryPersistModeUpdate())) {
                dbStateMachineConfig.setSagaRetryPersistModeUpdate(seataSagaProperties.getSagaRetryPersistModeUpdate());
            }
            if (Objects.nonNull(seataSagaProperties.getSagaCompensatePersistModeUpdate())) {
                dbStateMachineConfig.setSagaCompensatePersistModeUpdate(seataSagaProperties.getSagaCompensatePersistModeUpdate());
            }
            if (Objects.nonNull(seataSagaProperties.getServiceInvokeTimeout())) {
                dbStateMachineConfig.setServiceInvokeTimeout(seataSagaProperties.getServiceInvokeTimeout());
            }
            if (Objects.nonNull(seataSagaProperties.getTransOperationTimeout())) {
                dbStateMachineConfig.setTransOperationTimeout(seataSagaProperties.getTransOperationTimeout());
            }
            if (StringUtils.hasText((String)seataProperties.getApplicationId())) {
                dbStateMachineConfig.setApplicationId(seataProperties.getApplicationId());
            }
            if (StringUtils.hasText((String)seataProperties.getTxServiceGroup())) {
                dbStateMachineConfig.setTxServiceGroup(seataProperties.getTxServiceGroup());
            }
        }
    }
}

