/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql.transaction.seata.saga;

import com.digiwin.app.sql.transaction.seata.saga.DWSeataSagaAbstractResult;
import com.digiwin.app.sql.transaction.seata.saga.DWSeataSagaResponse;
import io.seata.saga.engine.AsyncCallback;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.statelang.domain.StateMachineInstance;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DWSeataSagaCallback
extends DWSeataSagaAbstractResult
implements AsyncCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(DWSeataSagaCallback.class);

    public void onFinished(ProcessContext context, StateMachineInstance stateMachineInstance) {
        DWSeataSagaResponse response = super.populateStateMachineResult(stateMachineInstance);
        this.doFinished(response);
    }

    public void onError(ProcessContext context, StateMachineInstance stateMachineInstance, Exception exp) {
        DWSeataSagaResponse response = super.populateStateMachineResult(stateMachineInstance);
        response.setErrorMsg(exp.getMessage());
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error(String.format("Error occurred while executing statemachine, businessKey:%s, stateMachineName:%s", response.getBusinessKey(), !Objects.isNull(response.getStateMachineDetail()) ? response.getStateMachineDetail().getStateMachineName() : ""), (Throwable)exp);
        }
        this.doError(response);
    }

    protected abstract void doFinished(DWSeataSagaResponse var1);

    protected abstract void doError(DWSeataSagaResponse var1);
}

