/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql.transaction.seata.aop;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DWSeataAbstractHttpInterceptor<T>
implements MethodInterceptor {
    static final Logger log = LoggerFactory.getLogger(DWSeataAbstractHttpInterceptor.class);
    private Class<T> targetArgumentType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Object o = invocation.getThis();
        Object[] arguments = invocation.getArguments();
        T targetArgument = this.getTargetArgument(arguments);
        if (targetArgument == null) {
            log.error("dwseata target argument(type=%s) is null, can not propagation info to callee API!", (Object)this.targetArgumentType.getName());
        } else {
            this.beforeInvoke(targetArgument);
        }
        try {
            Object result = method.invoke(o, arguments);
            this.afterInvoke(result);
            return result;
        }
        catch (Throwable e) {
            this.onException(e);
            throw e;
        }
    }

    protected T getTargetArgument(Object[] arguments) {
        Object targetArgument = null;
        for (Object argument : arguments) {
            if (!this.targetArgumentType.isAssignableFrom(argument.getClass())) continue;
            targetArgument = argument;
            break;
        }
        return (T)targetArgument;
    }

    protected abstract void beforeInvoke(T var1);

    private void onException(Throwable e) {
    }

    protected abstract void afterInvoke(Object var1);
}

