/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql.transaction.seata.aop;

import io.seata.common.util.StringUtils;
import io.seata.core.context.RootContext;
import io.seata.integration.http.XidResource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class DWSeataTransactionPropagationInterceptor
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DWSeataTransactionPropagationInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String rpcXid = request.getHeader("TX_XID");
        return this.bindXid(rpcXid);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (RootContext.inGlobalTransaction()) {
            String rpcXid = request.getHeader("TX_XID");
            this.cleanXid(rpcXid);
        }
    }

    protected boolean bindXid(String rpcXid) {
        String xid = RootContext.getXID();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("xid in RootContext[{}] xid in HttpContext[{}]", (Object)xid, (Object)rpcXid);
        }
        if (StringUtils.isBlank((String)xid) && StringUtils.isNotBlank((String)rpcXid)) {
            RootContext.bind((String)rpcXid);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("bind[{}] to RootContext", (Object)rpcXid);
            }
        }
        return true;
    }

    protected void cleanXid(String rpcXid) {
        XidResource.cleanXid((String)rpcXid);
    }
}

