/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql.transaction.seata.aop;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.sql.transaction.seata.DWSeataConstants;
import com.digiwin.app.sql.transaction.seata.DWSeataUtils;
import com.digiwin.app.sql.transaction.seata.aop.DWSeataAbstractHttpInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.core.annotation.Order;

@Order(value=100011)
public class DWSeataCustomizeHttpRequestInterceptor
extends DWSeataAbstractHttpInterceptor {
    @Override
    protected void beforeInvoke(Object targetArgument) {
        String xid = DWSeataUtils.getDtxId();
        if (StringUtils.isNotBlank((CharSequence)xid)) {
            if (HttpUriRequest.class.isAssignableFrom(targetArgument.getClass())) {
                this.setDistributedTransactionInfoFor4((HttpUriRequest)targetArgument);
            } else if (ClassicHttpRequest.class.isAssignableFrom(targetArgument.getClass())) {
                this.setDistributedTransactionInfoFor5((ClassicHttpRequest)targetArgument);
            }
        }
    }

    protected void setDistributedTransactionInfoFor4(HttpUriRequest targetArgument) {
        String xid = DWSeataUtils.getDtxId();
        if (StringUtils.isNotBlank((CharSequence)xid)) {
            xid = DWSeataUtils.deduplicateXid(xid);
            targetArgument.addHeader("TX_XID", xid);
            DWServiceContext.getContext().set(DWSeataConstants.KEY_HEADER_DIGIWIN_GTXID, (Object)xid);
            targetArgument.addHeader(DWSeataConstants.KEY_HEADER_DIGIWIN_GTXID, xid);
            log.info("[DWSeataCustomizeHttpRequestInterceptor] http client[4] add header key->'xid', value->'{}'", (Object)xid);
        }
    }

    private void setDistributedTransactionInfoFor5(ClassicHttpRequest targetArgument) {
        String xid = DWSeataUtils.getDtxId();
        if (StringUtils.isNotBlank((CharSequence)xid)) {
            xid = DWSeataUtils.deduplicateXid(xid);
            targetArgument.addHeader("TX_XID", (Object)xid);
            DWServiceContext.getContext().set(DWSeataConstants.KEY_HEADER_DIGIWIN_GTXID, (Object)xid);
            targetArgument.addHeader(DWSeataConstants.KEY_HEADER_DIGIWIN_GTXID, (Object)xid);
            log.info("[DWSeataCustomizeHttpRequestInterceptor] http client[5] add header key->'xid', value->'{}'", (Object)xid);
        }
    }

    @Override
    protected void afterInvoke(Object result) {
    }
}

