/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql.transaction.seata.filter;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.sql.transaction.seata.DWSeataConstants;
import com.digiwin.app.sql.transaction.seata.DWSeataUtils;
import com.digiwin.app.sql.transaction.seata.utils.DWSeataCustomRequestWrapper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DWSeataContextFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DWSeataContextFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[DWSeataContextFilter] init");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[DWSeataContextFilter] doFilter");
        }
        String rpcSeataTxXid = httpRequest.getHeader("TX_XID");
        String rpcDapTxXid = httpRequest.getHeader(DWSeataConstants.KEY_HEADER_DIGIWIN_GTXID);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[DWSeataContextFilter] {} ({}), digiwin {} ({})", new Object[]{"TX_XID", rpcSeataTxXid, DWSeataConstants.KEY_HEADER_DIGIWIN_GTXID, rpcDapTxXid});
        }
        LOGGER.info("[DWSeataContextFilter] {} ({}), digiwin {} ({})", new Object[]{"TX_XID", rpcSeataTxXid, DWSeataConstants.KEY_HEADER_DIGIWIN_GTXID, rpcDapTxXid});
        String xid = rpcSeataTxXid;
        if (StringUtils.hasText((String)rpcSeataTxXid) || StringUtils.hasText((String)rpcDapTxXid)) {
            if (!StringUtils.hasText((String)xid)) {
                xid = rpcDapTxXid;
            }
            LOGGER.debug("[DWSeataContextFilter] recover {} ({})", (Object)"TX_XID", (Object)xid);
            xid = DWSeataUtils.deduplicateXid(xid);
            DWSeataCustomRequestWrapper requestWrapper = new DWSeataCustomRequestWrapper(httpRequest);
            requestWrapper.addHeader("TX_XID", xid);
            DWServiceContext.getContext().getRequestHeader().put(DWSeataConstants.KEY_HEADER_DIGIWIN_GTXID, xid);
            DWServiceContext.getContext().set(DWSeataConstants.KEY_HEADER_DIGIWIN_GTXID, (Object)xid);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[DWSeataContextFilter] add request header({}, {})", (Object)"TX_XID", (Object)xid);
            }
            request = requestWrapper;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

