/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql.transaction.seata;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.sql.transaction.seata.DWSeataConstants;
import io.seata.core.context.RootContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DWSeataUtils {
    public static String getDtxId() {
        return RootContext.getXID();
    }

    public static void setDtxId(String xid) {
        DWServiceContext.getContext().set(DWSeataConstants.KEY_HEADER_DIGIWIN_GTXID, (Object)xid);
        RootContext.bind((String)xid);
    }

    public static boolean getSeataEnabled() {
        String seataEnabled = DWApplicationConfigUtils.getProperty((String)"seata.enabled", (String)"false");
        if (BooleanUtils.toBoolean((String)seataEnabled)) {
            return BooleanUtils.toBooleanObject((String)seataEnabled);
        }
        return false;
    }

    public static String deduplicateXid(String xid) {
        if (StringUtils.hasText((String)xid)) {
            List<String> xids = null;
            if (xid.contains(",")) {
                xids = Arrays.stream(xid.split(",")).toList();
            } else if (xid.contains(";")) {
                xids = Arrays.stream(xid.split(";")).toList();
            }
            if (!CollectionUtils.isEmpty(xids)) {
                xid = String.join((CharSequence)",", new HashSet<String>(xids));
            }
        }
        return xid;
    }
}

