/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.security;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class DWProgramAuthority {
    private static final String IAM_URL_PERMISSION_USER = "/api/iam/v2/permission/user/all";
    private static DWProgramAuthority instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DWProgramAuthority getInstance() {
        if (instance != null) return instance;
        Class<DWProgramAuthority> clazz = DWProgramAuthority.class;
        synchronized (DWProgramAuthority.class) {
            if (instance != null) return instance;
            instance = new DWProgramAuthority();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getAsJsonString(String userId) throws Exception {
        List<Map<String, Object>> programAuthorities = this.getAsList(userId);
        JSONArray ja = new JSONArray(programAuthorities);
        return ja.toString();
    }

    public List<Map<String, Object>> getAsList(String userId) throws Exception {
        String body = this.getIamResponseBody(userId);
        JSONObject jo = new JSONObject(body);
        JSONObject result = jo.getJSONObject("result");
        JSONArray permissions = result.getJSONArray("permissions");
        ArrayList<Map<String, Object>> programAuthorities = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < permissions.length(); ++i) {
            JSONObject condition;
            String target;
            String[] targetParts;
            JSONObject permission = permissions.getJSONObject(i);
            if (!permission.has("target") || (targetParts = (target = permission.optString("target", "")).split(":")).length < 6) continue;
            String module = targetParts[4];
            String programCode = targetParts[5];
            JSONObject conditions = permission.optJSONObject("conditions");
            if (conditions == null || (condition = conditions.optJSONObject(target)) == null) continue;
            Set keySet = condition.keySet();
            ArrayList functions = new ArrayList(keySet);
            HashMap<String, Object> programAuthority = new HashMap<String, Object>();
            programAuthority.put("module", module);
            programAuthority.put("programCode", programCode);
            programAuthority.put("functions", functions);
            programAuthorities.add(programAuthority);
        }
        return programAuthorities;
    }

    private String getIamResponseBody(String userId) throws Exception {
        ServiceModel serviceModel = new ServiceModel();
        String token = DWServiceContext.getContext().getToken();
        if (StringUtils.isNotBlank((CharSequence)token)) {
            serviceModel.setToken(token);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("target", "drn:iam:app:" + System.getProperty("appName", ""));
        HashMap<String, String> queryParameter = new HashMap<String, String>();
        queryParameter.put("effect", "onlyAllow");
        params.put("queryParameter", queryParameter);
        serviceModel.setParams(params);
        serviceModel.setInvokeURL(IAM_URL_PERMISSION_USER);
        HttpResponseModel response = (HttpResponseModel)IAMService.invoke((ServiceModel)serviceModel);
        int statusCode = response.getHttpStatusCode();
        String body = response.getResponseBody();
        if (statusCode != 200) {
            String message = "";
            if (this.isJSONObjectValid(body)) {
                JSONObject jo = new JSONObject(body);
                message = jo.optString("message", "");
            }
            throw new Exception(String.format("state code: %d, message: %s", statusCode, message));
        }
        return body;
    }

    private boolean isJSONObjectValid(String s) {
        try {
            new JSONObject(s);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

