/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sentinel.adapter.springwebmvc.config;

import com.alibaba.csp.sentinel.adapter.spring.webmvc_v6x.callback.BlockExceptionHandler;
import com.alibaba.csp.sentinel.adapter.spring.webmvc_v6x.config.SentinelWebMvcConfig;
import com.digiwin.sentinel.adapter.springwebmvc.callback.DWBlockExceptionHandler;
import com.digiwin.sentinel.adapter.springwebmvc.interceptor.DWDapSentinelWebInterceptor;
import com.digiwin.sentinel.adapter.springwebmvc.interceptor.DWSentinelWebInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnProperty(name={"dap.sentinel.enable"}, havingValue="true")
public class DWSentinelInterceptorConfig
implements WebMvcConfigurer {
    private static final Log log = LogFactory.getLog(DWSentinelInterceptorConfig.class);

    public void addInterceptors(InterceptorRegistry registry) {
        this.addSpringMvcInterceptor(registry);
    }

    private void addSpringMvcInterceptor(InterceptorRegistry registry) {
        SentinelWebMvcConfig config = new SentinelWebMvcConfig();
        config.setBlockExceptionHandler((BlockExceptionHandler)new DWBlockExceptionHandler());
        config.setWebContextUnify(true);
        registry.addInterceptor((HandlerInterceptor)this.creatDWSentinelWebInterceptor(config)).addPathPatterns(new String[]{"/**"});
    }

    private DWSentinelWebInterceptor creatDWSentinelWebInterceptor(SentinelWebMvcConfig config) {
        DWDapSentinelWebInterceptor sentinelWebInterceptor = null;
        try {
            Class.forName("com.digiwin.app.service.DWService");
            sentinelWebInterceptor = new DWDapSentinelWebInterceptor(config);
        }
        catch (Exception e) {
            log.warn((Object)"create sentinel interceptor object DWService not exist", (Throwable)e);
            sentinelWebInterceptor = new DWSentinelWebInterceptor(config);
        }
        if (sentinelWebInterceptor == null) {
            new DWSentinelWebInterceptor(config);
        }
        return sentinelWebInterceptor;
    }
}

