/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sentinel.config;

import com.digiwin.sentinel.DWSentinelProperties;
import com.digiwin.sentinel.cluster.config.DWSentinelClusterClientInitConfig;
import jakarta.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"dap.sentinel.enable"}, havingValue="true")
@AutoConfigureBefore(value={DWSentinelClusterClientInitConfig.class})
@EnableConfigurationProperties(value={DWSentinelProperties.class})
public class DWSentinelPropAutoConfiguration {
    @Autowired
    private DWSentinelProperties properties;

    @PostConstruct
    public void config() {
        if (this.isEmpty(System.getProperty("project.name")) && this.isNotEmpty(this.properties.getProjectName())) {
            System.setProperty("project.name", this.properties.getProjectName());
        }
        if (this.isEmpty(System.getProperty("csp.sentinel.app.type")) && this.isNotEmpty(this.properties.getAppType())) {
            System.setProperty("csp.sentinel.app.type", this.properties.getAppType());
        }
        if (this.isEmpty(System.getProperty("csp.sentinel.metric.file.single.size")) && this.isNotEmpty(this.properties.getMetricFileSingleSize())) {
            System.setProperty("csp.sentinel.metric.file.single.size", this.properties.getMetricFileSingleSize());
        }
        if (this.isEmpty(System.getProperty("csp.sentinel.metric.file.total.count")) && this.isNotEmpty(this.properties.getMetricFileTotalCount())) {
            System.setProperty("csp.sentinel.metric.file.total.count", this.properties.getMetricFileTotalCount());
        }
        if (this.isEmpty(System.getProperty("csp.sentinel.statistic.max.rt")) && this.isNotEmpty(this.properties.getStatisticMaxRt())) {
            System.setProperty("csp.sentinel.statistic.max.rt", this.properties.getStatisticMaxRt());
        }
        if (this.isEmpty(System.getProperty("csp.sentinel.spi.classloader")) && this.isNotEmpty(this.properties.getSpiClassloader())) {
            System.setProperty("csp.sentinel.spi.classloader", this.properties.getSpiClassloader());
        }
        if (this.isEmpty(System.getProperty("csp.sentinel.log.dir")) && this.isNotEmpty(this.properties.getLog().getDir())) {
            System.setProperty("csp.sentinel.log.dir", this.properties.getLog().getDir());
        }
        if (this.isEmpty(System.getProperty("csp.sentinel.log.use.pid")) && this.properties.getLog().isUsePid()) {
            System.setProperty("csp.sentinel.log.use.pid", String.valueOf(this.properties.getLog().isUsePid()));
        }
        if (this.isEmpty(System.getProperty("csp.sentinel.log.output.type")) && this.isNotEmpty(this.properties.getLog().getOutputType())) {
            System.setProperty("csp.sentinel.log.output.type", this.properties.getLog().getOutputType());
        }
        if (this.isEmpty(System.getProperty("csp.sentinel.dashboard.server")) && this.isNotEmpty(this.properties.getTransport().getDashboardServer())) {
            System.setProperty("csp.sentinel.dashboard.server", this.properties.getTransport().getDashboardServer());
        }
        if (this.isEmpty(System.getProperty("csp.sentinel.heartbeat.interval.ms")) && this.isNotEmpty(this.properties.getTransport().getHeartbeatIntervalMs())) {
            System.setProperty("csp.sentinel.heartbeat.interval.ms", this.properties.getTransport().getHeartbeatIntervalMs());
        }
        if (this.isEmpty(System.getProperty("csp.sentinel.api.port")) && this.isNotEmpty(this.properties.getTransport().getApiPort())) {
            System.setProperty("csp.sentinel.api.port", this.properties.getTransport().getApiPort());
        }
        if (this.isEmpty(System.getProperty("csp.sentinel.heartbeat.client.ip")) && this.isNotEmpty(this.properties.getTransport().getHeartbeatClientIp())) {
            System.setProperty("csp.sentinel.heartbeat.client.ip", this.properties.getTransport().getHeartbeatClientIp());
        }
    }

    private boolean isNotEmpty(String str) {
        return !this.isEmpty(str);
    }

    private boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }
}

