/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sentinel.datasource;

import com.alibaba.csp.sentinel.cluster.ClusterStateManager;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientAssignConfig;
import com.alibaba.csp.sentinel.transport.config.TransportConfig;
import com.alibaba.csp.sentinel.util.HostNameUtil;
import com.digiwin.sentinel.cluster.entity.ClusterGroupEntity;
import com.digiwin.sentinel.datasource.DWSentinelClusterClientDataSource;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public abstract class DWAbstractSentinelClusterClientDataSource
implements DWSentinelClusterClientDataSource {
    private static final String SEPARATOR = "@";

    @Override
    public void initClusterClient() {
        this.initDynamicRuleProperty();
        this.initClientConfigProperty();
        this.initClientServerAssignProperty();
        this.initStateProperty();
    }

    public abstract void initDynamicRuleProperty();

    public abstract void initClientConfigProperty();

    public abstract void initClientServerAssignProperty();

    public void initStateProperty() {
        ClusterStateManager.applyState((Integer)0);
    }

    protected Optional<ClusterClientAssignConfig> extractClientAssignment(List<ClusterGroupEntity> groupList) {
        if (groupList.stream().anyMatch(this::machineEqual)) {
            return Optional.empty();
        }
        Iterator<ClusterGroupEntity> iterator = groupList.iterator();
        if (iterator.hasNext()) {
            ClusterGroupEntity group = iterator.next();
            String ip = group.getIp();
            Integer port = group.getPort();
            return Optional.of(new ClusterClientAssignConfig(ip, port));
        }
        return Optional.empty();
    }

    private boolean machineEqual(ClusterGroupEntity group) {
        return this.getCurrentMachineId().equals(group.getMachineId());
    }

    private String getCurrentMachineId() {
        return HostNameUtil.getIp() + SEPARATOR + TransportConfig.getRuntimePort();
    }
}

