/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.server;

import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.module.utils.DWResourceUtils;
import com.digiwin.app.server.DWConsole;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.StopWatch;

public class DWServer {
    private static final String ARGUMENT_TITLE = "title";
    private static final String ARGUMENT_CONSOLE_MODE = "console";
    private static final String ARGUMENT_SPRING_CONFIG_FILE_NAME = "springconfigfilename";
    private static final String ARGUMENT_START_PROPERTIES_FILE_NAME = "starpropertiesfilename";
    private static final String CONSOLE_MODE = "c";
    private static final String NONE_CONSOLE_MODE = "n";
    protected static Log log = LogFactory.getLog(DWServer.class);
    private DWConsole _console;
    private Map<String, String> _arguments;

    private boolean isConsoleMode() {
        String value = this._arguments.get(ARGUMENT_CONSOLE_MODE);
        return CONSOLE_MODE.equals(value);
    }

    public static String getTitleArgument(String title) {
        return "title:" + title;
    }

    public static String getConsoleModeArgument(boolean consoleMode) {
        String consoleModeValue = consoleMode ? CONSOLE_MODE : NONE_CONSOLE_MODE;
        return "console:" + consoleModeValue;
    }

    public static String getSpringConfigFileNameArgument(String springConfigFileName) {
        if (springConfigFileName == null || springConfigFileName.isEmpty()) {
            return null;
        }
        return "springconfigfilename:" + springConfigFileName;
    }

    public static String getStartPropertiesFilenameArgument(String startPropertiesFileName) {
        if (startPropertiesFileName == null || startPropertiesFileName.isEmpty()) {
            return null;
        }
        return "starpropertiesfilename:" + startPropertiesFileName;
    }

    public static void main(String[] args) {
        List<String> arguments = Arrays.asList(args);
        arguments.add(DWServer.getTitleArgument("Digiwin Schedule Server"));
        arguments.add(DWServer.getSpringConfigFileNameArgument("spring-config.xml"));
        DWServer server = new DWServer();
        server.start(arguments);
    }

    public final void start(List<String> args) {
        this.initializeArguments(args);
        this.start();
    }

    private final void start() {
        if (this.isConsoleMode()) {
            this._console = new DWConsole(this._arguments.get(ARGUMENT_TITLE));
        }
        this.addShutdownHook();
        Runnable serverRunner = new Runnable(){

            @Override
            public void run() {
                StopWatch stopWatch = new StopWatch("Digiwin Schedule Server Stop Watch");
                stopWatch.start("server start");
                log.info((Object)"Server starting...");
                DWServer.this.startCore();
                stopWatch.stop();
                long diffs = stopWatch.getLastTaskTimeMillis();
                log.info((Object)("Server startup in " + diffs + " ms"));
            }
        };
        Thread serverThread = new Thread(serverRunner, "server");
        serverThread.start();
        if (this.isConsoleMode()) {
            this.scanConsole();
        } else {
            this.waitServer();
        }
    }

    private void applyPropertiesToArguments() {
        if (!this._arguments.containsKey(ARGUMENT_START_PROPERTIES_FILE_NAME)) {
            return;
        }
        String propertiesFileName = this._arguments.get(ARGUMENT_START_PROPERTIES_FILE_NAME);
        if (propertiesFileName == null || propertiesFileName.isEmpty()) {
            return;
        }
        try {
            Properties serverStartProperties = DWResourceUtils.getProperties((String)propertiesFileName);
            for (Object key : serverStartProperties.keySet()) {
                String keyString;
                if (key == null || this._arguments.containsKey(keyString = key.toString().toLowerCase())) continue;
                String value = serverStartProperties.getProperty(key.toString());
                this._arguments.put(key.toString(), value);
            }
        }
        catch (Exception e) {
            StringBuilder message = new StringBuilder();
            message.append("initializeArguments read file:");
            message.append(propertiesFileName).append(" failed!");
            log.error((Object)message.toString(), (Throwable)e);
        }
    }

    private void initializeArguments(List<String> args) {
        this._arguments = new HashMap<String, String>();
        if (args == null) {
            return;
        }
        for (String argument : args) {
            if (argument == null || argument.isEmpty()) continue;
            if (CONSOLE_MODE.equals(argument.toLowerCase())) {
                this._arguments.put(ARGUMENT_CONSOLE_MODE, CONSOLE_MODE);
                continue;
            }
            String[] parts = argument.split(":");
            this._arguments.put(parts[0].toLowerCase(), parts[1]);
        }
        this.applyPropertiesToArguments();
    }

    private void scanConsole() {
        if (this._console != null) {
            Scanner scanner = this._console.getScanner();
            while (true) {
                String command;
                if (!"q".equals(command = scanner.nextLine())) {
                    continue;
                }
                System.exit(0);
            }
        }
    }

    private void waitServer() {
        Class<DWServer> clazz = DWServer.class;
        synchronized (DWServer.class) {
            while (true) {
                try {
                    while (true) {
                        DWServer.class.wait();
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.info((Object)">>> java runtime shutdown hook <<<");
                DWServer.this.shutdown();
            }
        });
    }

    protected void startCore() {
        String classRootPath = DWResourceUtils.getClassRootPath(DWResourceUtils.class).getPath();
        log.info((Object)("class path =" + classRootPath));
        this.logSystemLibraries();
        this.startSpring();
    }

    private void logSystemLibraries() {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        URL[] urls = ((URLClassLoader)cl).getURLs();
        int i = 0;
        StringBuilder libraries = new StringBuilder();
        for (URL url : urls) {
            libraries.append(">library ").append(++i).append(".");
            libraries.append(url.getFile());
        }
        log.debug((Object)libraries.toString());
    }

    protected void startSpring() {
        this.loadSpringConfig();
    }

    protected void loadSpringConfig() {
        String springConfigFileName = this._arguments.get(ARGUMENT_SPRING_CONFIG_FILE_NAME);
        if (springConfigFileName == null || springConfigFileName.isEmpty()) {
            return;
        }
        String[] springConfigFileNames = springConfigFileName.split(",");
        String[] configArray = new String[springConfigFileNames.length];
        for (int i = 0; i < springConfigFileNames.length; ++i) {
            String configPath;
            String eachConfigFileName = springConfigFileNames[i];
            File springConfigFile = DWResourceUtils.getFile((String)eachConfigFileName);
            if (springConfigFile == null) {
                log.error((Object)("Spring config:" + eachConfigFileName + " not found!"));
                return;
            }
            log.info((Object)("> " + i + ". Spring config: " + eachConfigFileName + " found!"));
            configArray[i] = configPath = "file:" + springConfigFile.getAbsolutePath();
        }
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext(configArray, true);
    }

    public final void shutdown() {
        log.info((Object)">>> starting Server shutdown process...");
        try {
            this.shutdownCore();
        }
        finally {
            this._console = null;
        }
        log.info((Object)">>> shutdown completed!");
    }

    protected void shutdownCore() {
        this.shutdowSpring();
    }

    protected void shutdowSpring() {
        log.info((Object)"> close Spring context...");
        ((ClassPathXmlApplicationContext)SpringContextUtils.getContext()).close();
    }
}

