/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.server;

import java.awt.Font;
import java.awt.event.WindowEvent;
import java.util.Scanner;
import javaConsole.JavaConsole;

public class DWConsole {
    private boolean _quit;
    private JavaConsole _console;
    private Scanner _scanner;
    private String _title = "Digiwin Console";
    private String _subTitle;

    public DWConsole(String title) {
        if (title != null && !title.isEmpty()) {
            this._title = title;
        }
        this.createGUIConsol();
        this._scanner = new Scanner(System.in);
        this.refreshConsoleCaption();
    }

    public void setSubtitle(String subtitle) {
        this._subTitle = subtitle;
    }

    public void setFont(Font font) {
        if (font != null) {
            this._console.setFont(font);
        }
    }

    public Scanner getScanner() {
        return this._scanner;
    }

    private void refreshConsoleCaption() {
        StringBuilder caption = new StringBuilder();
        caption.append(this._title);
        if (this._subTitle != null && !this._subTitle.isEmpty()) {
            caption.append(" - ").append(this._subTitle);
        }
        this._console.setTitle(caption.toString());
    }

    private void createGUIConsol() {
        this._console = new JavaConsole(){

            public synchronized void windowClosed(WindowEvent evt) {
                DWConsole.this._quit = true;
                super.windowClosed(evt);
            }
        };
        this._console.setFont(new Font("Arial Unicode MS", 0, 14));
    }

    public boolean isQuit() {
        return this._quit;
    }
}

