/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.utils;

import com.digiwin.app.service.DWServiceChainContext;
import com.digiwin.app.service.DWServiceChainInfoProvider;
import com.digiwin.app.service.DWServiceChainInfoStorage;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;

public class DWServiceChainUtils {
    public static String HEADER_KEY_SERVICE_CHAIN_INFO = "digi-dap-service-chain-info";
    private static Log log = LogFactory.getLog(DWServiceChainUtils.class);
    private static String identity;
    private static Consumer<DWServiceChainContext> receivedPrinter;

    public static void setIdentity(String id) {
        identity = id;
    }

    public static String getIdentity() {
        return identity;
    }

    public static void setPrinterType(String type) {
        if ("full".equalsIgnoreCase(type)) {
            receivedPrinter = DWServiceChainUtils::fullInfoPrinter;
        }
    }

    public static boolean isServiceChainEnabled() {
        return identity != null;
    }

    public static void beforeInvokeOutterAPI(DWServiceChainInfoStorage sessionInfoStorage) {
        DWServiceChainContext context = DWServiceChainContext.getContext();
        context.increaseInvocationCount();
        if (sessionInfoStorage == null) {
            log.warn((Object)"beforeInvokeOutterAPI sessionInfoStorage is null, can not pass session info to next API!");
        } else {
            String sessionInfo = context.getSessionInfo();
            sessionInfoStorage.save(HEADER_KEY_SERVICE_CHAIN_INFO, sessionInfo);
        }
    }

    public static void initContext(DWServiceChainInfoProvider sessionInfoProvider) {
        Object result;
        String sessionInfoString = null;
        if (sessionInfoProvider != null && (result = sessionInfoProvider.get(HEADER_KEY_SERVICE_CHAIN_INFO)) != null) {
            sessionInfoString = result.toString();
        }
        String selfAppId = identity;
        DWServiceChainContext context = DWServiceChainContext.getContext();
        context.initialize(selfAppId, sessionInfoString);
        ThreadContext.put((String)"sessionId", (String)context.getId());
        if (context.isRoot()) {
            log.info((Object)String.format("root invocation> %s", context.getId()));
        } else {
            receivedPrinter.accept(context);
        }
    }

    private static void standardPriner(DWServiceChainContext context) {
        log.info((Object)String.format("trace info> me: %s, layer=%s from parent> %s (appId=%s seq=%s)", context.getId(), context.getLayer(), context.getParentId(), context.getParentAppId(), context.getTraceElement().getSeq()));
    }

    private static void fullInfoPrinter(DWServiceChainContext context) {
        log.info((Object)context.getTraceElement().getTraceInfo(true));
    }

    static {
        receivedPrinter = DWServiceChainUtils::standardPriner;
    }
}

