/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.interceptor.log;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class DWRabbitmqProducerLogInterceptor
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(DWRabbitmqProducerLogInterceptor.class);
    private Environment environment;

    public DWRabbitmqProducerLogInterceptor(Environment environment) {
        this.environment = environment;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        String methodName;
        ThreadContext.put((String)"nodeType", (String)"rabbitmq-producer");
        ThreadContext.put((String)"type", (String)"rabbitmq-producer-req");
        ThreadContext.put((String)"paramSize", (String)"");
        ThreadContext.put((String)"timeConsume", (String)"");
        String nodeId = methodName = methodInvocation.getMethod().getName();
        ThreadContext.put((String)"nodeId", (String)nodeId);
        logger.info("Start send rabbitmq message, execution method: {}", (Object)methodName);
        long startTime = System.currentTimeMillis();
        Object result = methodInvocation.proceed();
        long endTime = System.currentTimeMillis();
        long executionTime = endTime - startTime;
        ThreadContext.put((String)"type", (String)"rabbitmq-consumer-resp");
        ThreadContext.put((String)"timeConsume", (String)String.valueOf(executionTime));
        logger.info("Finish send rabbitmq message");
        return result;
    }
}

