/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.commons.service;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWPaginationQueryResult;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.service.commons.service.ICrudService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

public class CrudService
implements ICrudService {
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;

    @Override
    @Transactional
    public Object put(DWDataSet dataset) throws Exception {
        DWSQLExecutionResult result = this.dao.execute(dataset);
        return DWServiceResultBuilder.build((Object)result);
    }

    @Override
    @Transactional
    public Object post(DWDataSet dataset) throws Exception {
        DWSQLExecutionResult result = this.dao.execute(dataset);
        return DWServiceResultBuilder.build((Object)result);
    }

    @Override
    @Transactional
    public Object delete(DWDataSet dataset) throws Exception {
        DWSQLExecutionResult result = this.dao.execute(dataset);
        return DWServiceResultBuilder.build((Object)result);
    }

    @Override
    public Object get(DWQueryInfo queryInfo, String tableName) throws Exception {
        queryInfo.setTableName(tableName);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        DWDataSet result = this.dao.select(queryInfo, option);
        return DWServiceResultBuilder.build((Object)result);
    }

    @Override
    public Object getList(DWPagableQueryInfo queryInfo, String tableName) throws Exception {
        queryInfo.setTableName(tableName);
        DWPaginationQueryResult result = this.dao.selectWithPage(queryInfo);
        return DWServiceResultBuilder.build((Object)result);
    }
}

