/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.eai;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DWEAIHeader
extends DWHeader {
    private String eaiServiceId;
    private DWMethod mappingMethod;
    private boolean isCallback;

    public DWEAIHeader(String moduleName, String eaiServiceId, Class<?> serviceType) {
        super(moduleName, serviceType);
        if (eaiServiceId == null || eaiServiceId.isEmpty()) {
            throw new IllegalArgumentException("eaiServiceId is null or empty!");
        }
        this.eaiServiceId = eaiServiceId;
    }

    public String getEAIServiceId() {
        return this.eaiServiceId;
    }

    protected void setMappingMethod(Method method, boolean isCallback) {
        Objects.requireNonNull(method);
        if (this.mappingMethod != null) {
            throw new IllegalStateException("mapping method is already exist!");
        }
        this.mappingMethod = this.createDWMethod(method);
        this.isCallback = isCallback;
    }

    public boolean isCallback() {
        return this.isCallback;
    }

    public DWMethod getMappingMethod() {
        return this.mappingMethod;
    }

    public Map<String, List<DWMethod>> getDWMethods() {
        if (this.mappingMethod == null) {
            throw new IllegalStateException("mapping method not set yet!");
        }
        HashMap<String, List<DWMethod>> dwMethods = new HashMap<String, List<DWMethod>>();
        ArrayList<DWMethod> methodList = new ArrayList<DWMethod>();
        methodList.add(this.mappingMethod);
        dwMethods.put(this.mappingMethod.getMethodName(), methodList);
        return dwMethods;
    }

    public boolean equals(Object comparedObject) {
        if (!(comparedObject instanceof DWEAIHeader)) {
            return false;
        }
        DWEAIHeader comparedHeader = (DWEAIHeader)((Object)comparedObject);
        return this.eaiServiceId.equals(comparedHeader.getEAIServiceId());
    }
}

