/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.eai;

import com.digiwin.app.container.DWAbstractServiceDefinitionParser;
import com.digiwin.app.container.DWHeaderRegistry;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.app.service.eai.EAICallback;
import com.digiwin.app.service.eai.EAIService;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DWEAIServiceDefinitionParser
extends DWAbstractServiceDefinitionParser<DWEAIHeader> {
    public DWEAIServiceDefinitionParser(DWEAIHeaderRepository headerRepository) {
        super((DWHeaderRegistry)headerRepository, null);
    }

    public void parseInterface(String groupName, List<Class<?>> interfaceClassList) {
        ArrayList<DWEAIHeader> headers = new ArrayList<DWEAIHeader>();
        for (Class<?> interfaceType : interfaceClassList) {
            for (Method method : interfaceType.getMethods()) {
                DWEAIHeader header;
                if (method.isAnnotationPresent(EAIService.class)) {
                    EAIService eaiService = method.getAnnotation(EAIService.class);
                    header = new DWEAIHeader(groupName, eaiService.id(), interfaceType);
                    header.setMappingMethod(method, false);
                    headers.add(header);
                }
                if (!method.isAnnotationPresent(EAICallback.class)) continue;
                EAICallback eaiCallback = method.getAnnotation(EAICallback.class);
                header = new DWEAIHeader(groupName, eaiCallback.id(), interfaceType);
                header.setMappingMethod(method, true);
                headers.add(header);
            }
        }
        this.registerHeader(groupName, headers);
    }

    public void parseImplementation(Map<String, List<DWServiceInfo>> implementationClassList) {
    }

    public void parseImplementation(String groupName, List<DWServiceInfo> implementationClassList) {
    }
}

