/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.eai;

import com.digiwin.app.container.DWAbstractHeaderRepository;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.DWEAIServiceLocationInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DWEAIHeaderRepository
extends DWAbstractHeaderRepository<DWEAIHeader, DWEAIServiceLocationInfo> {
    protected void afterRegister(String groupName, List<DWEAIHeader> headers, List<DWEAIHeader> oldHeaders) {
        headers.forEach(h -> log.info((Object)String.format("  |_____id=%s, is callback=%s, %s.%s", h.getEAIServiceId(), h.isCallback(), h.getServiceType().getName(), h.getMappingMethod().getMethodName())));
    }

    protected DWTargetAPI searchAPI(DWEAIServiceLocationInfo locationInfo) {
        DWEAIHeader eaiHeader = locationInfo.isCallback() ? this.getEaiCallbackHeader(locationInfo.getEAIServiceId()) : this.getEaiServiceHeader(locationInfo.getEAIServiceId());
        return eaiHeader == null ? null : new DWTargetAPI((DWHeader)eaiHeader, eaiHeader.getMappingMethod());
    }

    public List<String> getEaiServiceIdList() {
        ArrayList<String> eaiServiceList = new ArrayList<String>();
        for (List headers : this.headers.values()) {
            eaiServiceList.addAll(headers.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList()));
        }
        return eaiServiceList;
    }

    public DWEAIHeader getEaiServiceHeader(String eaiServiceId) {
        return this.findFirstHeader(h -> h.getEAIServiceId().equals(eaiServiceId));
    }

    public DWMethod getEaiServiceMethod(String eaiServiceId) {
        DWEAIHeader targetHeader = this.getEaiServiceHeader(eaiServiceId);
        return targetHeader == null ? null : targetHeader.getMappingMethod();
    }

    public DWEAIHeader getEaiCallbackHeader(String eaiServiceId) {
        return this.findFirstHeader(h -> h.isCallback() && h.getEAIServiceId().equals(eaiServiceId));
    }

    public DWMethod getEaiCallbackMethod(String eaiServiceId) {
        DWEAIHeader targetHeader = this.getEaiCallbackHeader(eaiServiceId);
        return targetHeader == null ? null : targetHeader.getMappingMethod();
    }

    private DWEAIHeader findFirstHeader(Predicate<DWEAIHeader> predicate) {
        List groupHeaders;
        DWEAIHeader targetHeader = null;
        Iterator iterator = this.headers.values().iterator();
        while (iterator.hasNext() && (targetHeader = (DWEAIHeader)(groupHeaders = (List)iterator.next()).stream().filter(predicate).findFirst().orElse(null)) == null) {
        }
        return targetHeader;
    }
}

