/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.service.permission;

import com.digiwin.gateway.service.permission.DWSecurityContext;
import com.digiwin.gateway.service.permission.util.DWSecurityTokenUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpUriRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;

@Aspect
public class DWSecurityInterceptor {
    private static final Log log = LogFactory.getLog(DWSecurityInterceptor.class);

    @Before(value="execution(* org.apache.http.client.HttpClient.execute(..)) && args(httpUriRequest)")
    public void beforeHttpClientExecute(JoinPoint joinPoint, HttpUriRequest httpUriRequest) throws Exception {
        DWSecurityContext securityContext = DWSecurityContext.getSecurityContext();
        String securityToken = DWSecurityTokenUtil.generateSecurityToken(securityContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("create security-token : " + securityToken));
        }
        httpUriRequest.addHeader("security-token", securityToken);
    }
}

