/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.service.permission;

import java.util.Map;

public class DWSecurityContext {
    private static ThreadLocal<DWSecurityContext> currentSecurityContext = new ThreadLocal();
    private boolean tokenVerified;
    private boolean userVerified;
    private boolean appVerified;
    private String appToken;
    private String userToken;
    private Map<String, Object> profile;

    DWSecurityContext() {
    }

    public static DWSecurityContext getSecurityContext() {
        DWSecurityContext securityContext = currentSecurityContext.get();
        if (null == securityContext) {
            securityContext = new DWSecurityContext();
            currentSecurityContext.set(securityContext);
        }
        return securityContext;
    }

    public void remove() {
        currentSecurityContext.remove();
    }

    protected static void setSecurityContext(DWSecurityContext securityContext) {
        currentSecurityContext.set(securityContext);
    }

    public void setTokenVerified() {
        this.tokenVerified = true;
    }

    public void setUserVerified() {
        this.userVerified = true;
    }

    public void setAppVerified() {
        this.appVerified = true;
    }

    public void setProfile(Map<String, Object> profile) {
        this.profile = profile;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public boolean isTokenVerified() {
        return this.tokenVerified;
    }

    public boolean isUserVerified() {
        return this.userVerified;
    }

    public boolean isAppVerified() {
        return this.appVerified;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public String getUserToken() {
        return this.userToken;
    }

    public Map<String, Object> getProfile() {
        return this.profile;
    }
}

