/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.service.permission;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;

public class DWSecurityContext
implements Serializable {
    private static ThreadLocal<DWSecurityContext> currentSecurityContext = new ThreadLocal();
    private boolean tokenVerified;
    private boolean userVerified;
    private boolean appVerified;
    private String appToken;
    private String userToken;
    private Map<String, Object> profile;

    DWSecurityContext() {
    }

    public static DWSecurityContext getSecurityContext() {
        DWSecurityContext securityContext = currentSecurityContext.get();
        if (null == securityContext) {
            securityContext = new DWSecurityContext();
            currentSecurityContext.set(securityContext);
        }
        return securityContext;
    }

    public void remove() {
        currentSecurityContext.remove();
    }

    public static void setSecurityContext(DWSecurityContext securityContext) {
        currentSecurityContext.set(securityContext);
    }

    public void setTokenVerified() {
        this.tokenVerified = true;
    }

    public void setUserVerified() {
        this.userVerified = true;
    }

    public void setAppVerified() {
        this.appVerified = true;
    }

    public void setProfile(Map<String, Object> profile) {
        this.profile = profile;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public boolean isTokenVerified() {
        return this.tokenVerified;
    }

    public boolean isUserVerified() {
        return this.userVerified;
    }

    public boolean isAppVerified() {
        return this.appVerified;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public String getUserToken() {
        return this.userToken;
    }

    public Map<String, Object> getProfile() {
        return this.profile;
    }

    public DWSecurityContext deepClone() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ObjectOutputStream objOutput = new ObjectOutputStream(output);
        objOutput.writeObject(this);
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        ObjectInputStream objInput = new ObjectInputStream(input);
        return (DWSecurityContext)objInput.readObject();
    }
}

