/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.service.permission;

import com.digiwin.gateway.service.permission.DWSecurityContext;
import com.digiwin.gateway.service.permission.config.DWServicePermissionConfig;
import com.digiwin.gateway.service.permission.pojo.DWSecurityToken;
import com.digiwin.gateway.service.permission.util.DWSecurityTokenUtil;
import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class DWSecurityContextInitFilter
implements Filter {
    private static final Log log = LogFactory.getLog(DWSecurityContextInitFilter.class);
    public static final String KEY_SECURITY_TOKEN = "security-token";
    public static final String KEY_USER_TOKEN = "token";
    public static final String KEY_APP_TOKEN = "digi-middleware-auth-app";
    @Autowired
    @Qualifier(value="dw-service-permission-config")
    DWServicePermissionConfig servicePermissionConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        DWSecurityContext securityContext = DWSecurityContext.getSecurityContext();
        securityContext.remove();
        String securityToken = req.getHeader(KEY_SECURITY_TOKEN);
        boolean openTrustChain = this.servicePermissionConfig.isOpenTrustChain();
        if (null != securityToken && !securityToken.trim().isEmpty()) {
            try {
                DWSecurityToken securityTokenBean = DWSecurityTokenUtil.parseSecurityToken(securityToken);
                DWSecurityContext context = securityTokenBean.getContext();
                Instant expirationTime = Instant.ofEpochMilli(securityTokenBean.getExpirationTime());
                if (!expirationTime.isBefore(Instant.now())) {
                    DWSecurityContext.setSecurityContext(context);
                } else {
                    Map<String, Object> profile = context.getProfile();
                    DWSecurityContext.getSecurityContext().setProfile(profile);
                }
            }
            catch (Exception e) {
                log.warn((Object)String.format("\u4f7f\u7528[%s]\u9084\u539f\u5b89\u5168\u4e0a\u4e0b\u6587\u6642\u51fa\u932f, \u4f7f\u7528\u5e73\u53f0\u9ed8\u8a8d\u5b89\u5168\u4e0a\u4e0b\u6587", securityToken), (Throwable)e);
            }
        }
        chain.doFilter(request, response);
    }
}

