/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.service.permission;

import com.digiwin.app.resource.DWApplicationMessageResourceBundleUtils;
import com.digiwin.gateway.service.permission.DWSecurityContext;
import com.digiwin.gateway.service.permission.config.DWServicePermissionConfig;
import com.digiwin.gateway.service.permission.util.DWSecurityRequestUtil;
import com.digiwin.service.permission.auth.DWAuthorizationVerifier;
import com.digiwin.service.permission.auth.DWIAMAuthorizationVerifier;
import com.digiwin.service.permission.auth.param.SubscriptionApiPermissionParam;
import com.digiwin.service.permission.auth.param.TenantPermissionParam;
import com.digiwin.service.permission.auth.param.UserPermissionParam;
import com.digiwin.service.permission.util.EAIServiceInfoUtil;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class DWServicePermissionFilter
implements Filter {
    private static final Log log = LogFactory.getLog(DWServicePermissionFilter.class);
    static final String ERROR_CODE = "10905";
    @Autowired
    @Qualifier(value="dw-service-permission-config")
    DWServicePermissionConfig servicePermissionConfig;
    DWAuthorizationVerifier authorizationVerifier = new DWIAMAuthorizationVerifier();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        boolean allowAnonymous = false;
        Object isDWMethodAllowAnonymous = req.getAttribute("isDWMethodAllowAnonymous");
        if (null != isDWMethodAllowAnonymous) {
            allowAnonymous = (Boolean)isDWMethodAllowAnonymous;
        }
        if (!allowAnonymous) {
            boolean needValidSubscription = this.servicePermissionConfig.isValidSubscriptionPermission();
            if (needValidSubscription) {
                boolean validFailed = this.validSubscriptionPermission(req, resp);
                if (validFailed) {
                    return;
                }
            } else {
                boolean needValidUser = this.servicePermissionConfig.isValidUserPermission();
                boolean needValidTenant = this.servicePermissionConfig.isValidTenantPermission();
                DWSecurityContext securityContext = DWSecurityContext.getSecurityContext();
                boolean userVerified = securityContext.isUserVerified();
                log.debug((Object)String.format("\u8abf\u7528\u93c8\u8def\u4e2d\u662f\u5426\u9a57\u8b49\u904e\u7528\u6236\u7d1a\u670d\u52d9\u6b0a\u9650\uff1a%s\uff0c\u8981\u9a57\u8b49\u7528\u6236\u670d\u52d9\u6b0a\u9650\uff1a%s\uff0c\u8981\u9a57\u8b49\u79df\u6236\u670d\u52d9\u6b0a\u9650\uff1a%s", userVerified, needValidUser, needValidTenant));
                boolean validFailed = false;
                if (needValidUser) {
                    validFailed = !userVerified ? this.validUserPermission(req, resp) : this.validTenantPermission(req, resp);
                } else if (needValidTenant) {
                    log.debug((Object)"\u9a57\u8b49\u79df\u6236\u7d1a\u5225\u7684\u670d\u52d9\u6b0a\u9650\uff01\uff01\uff01");
                    validFailed = this.validTenantPermission(req, resp);
                }
                if (validFailed) {
                    return;
                }
            }
        }
        DWSecurityContext.getSecurityContext().setAppToken(this.servicePermissionConfig.getAppToken());
        chain.doFilter(request, response);
    }

    private boolean validUserPermission(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        log.debug((Object)"*** \u958b\u59cb\u9a57\u8b49\u7528\u6236\u670d\u52d9\u6b0a\u9650 ***");
        DWSecurityContext securityContext = DWSecurityContext.getSecurityContext();
        Map profile = securityContext.getProfile();
        String appId = this.servicePermissionConfig.getAppId();
        String path = this.getPath(req);
        String method = req.getMethod();
        String appToken = req.getHeader("digi-middleware-auth-app");
        if (Objects.isNull(appToken)) {
            appToken = this.servicePermissionConfig.getAppToken();
        }
        String tableName = null;
        Set<String> tables = DWSecurityRequestUtil.getTableNames(req);
        if (!tables.isEmpty()) {
            tableName = tables.toArray(new String[0])[0];
        }
        UserPermissionParam param = new UserPermissionParam();
        param.setAppId(appId);
        param.setPath(path);
        param.setMethod(method);
        param.setAppToken(appToken);
        param.setTableName(tableName);
        param.setTenantId(Objects.toString(profile.get("tenantId")));
        param.setTenantSid(Long.valueOf(Long.parseLong(Objects.toString(profile.get("tenantSid")))));
        param.setUserId(Objects.toString(profile.get("userId")));
        param.setUserSid(Long.valueOf(Long.parseLong(Objects.toString(profile.get("userSid")))));
        try {
            log.debug((Object)String.format("\u53c3\u6578 => %s, \u8abf\u7528IAM\u9032\u884c\u7528\u6236\u670d\u52d9\u6b0a\u9650\u9a57\u8b49\u3002", param));
            Map result = this.authorizationVerifier.verifyUserServicePermission(this.servicePermissionConfig.getRamHostUrl(), param);
            securityContext.setUserVerified();
            DWSecurityContext.setSecurityContext((DWSecurityContext)securityContext);
            log.debug((Object)String.format("IAM\u9032\u884c\u7528\u6236\u670d\u52d9\u6b0a\u9650\u9a57\u8b49\u7d50\u679c => %s", result));
        }
        catch (Exception e) {
            String bodyString = e.getMessage();
            String errorMessage = DWApplicationMessageResourceBundleUtils.getApplicationResourceBundle((String)ERROR_CODE, (String)ERROR_CODE, (Object[])new Object[]{appId, path, method});
            this.generateErrorResponse(resp, bodyString, errorMessage);
            return true;
        }
        return false;
    }

    private boolean validTenantPermission(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        log.debug((Object)"*** \u958b\u59cb\u9a57\u8b49\u79df\u6236\u670d\u52d9\u6b0a\u9650 ***");
        DWSecurityContext securityContext = DWSecurityContext.getSecurityContext();
        Map profile = securityContext.getProfile();
        String appId = this.servicePermissionConfig.getAppId();
        String path = this.getPath(req);
        String method = req.getMethod();
        String appToken = securityContext.getAppToken();
        if (Objects.isNull(appToken)) {
            appToken = req.getHeader("digi-middleware-auth-app");
        }
        TenantPermissionParam param = new TenantPermissionParam();
        param.setAppId(appId);
        param.setPath(path);
        param.setMethod(method);
        param.setAppToken(appToken);
        param.setTenantId(Objects.toString(profile.get("tenantId")));
        param.setTenantSid(Long.valueOf(Long.parseLong(Objects.toString(profile.get("tenantSid")))));
        try {
            log.debug((Object)String.format("\u53c3\u6578 => %s, \u8abf\u7528IAM\u9032\u884c\u79df\u6236\u7d1a\u5225\u670d\u52d9\u6b0a\u9650\u9a57\u8b49\u3002", param));
            Map result = this.authorizationVerifier.verifyTenantServicePermission(this.servicePermissionConfig.getRamHostUrl(), param);
            log.debug((Object)String.format("IAM\u9032\u884c\u79df\u6236\u7d1a\u5225\u670d\u52d9\u6b0a\u9650\u9a57\u8b49\u7d50\u679c => %s", result));
        }
        catch (Exception e) {
            String bodyString = e.getMessage();
            String errorMessage = DWApplicationMessageResourceBundleUtils.getApplicationResourceBundle((String)ERROR_CODE, (String)ERROR_CODE, (Object[])new Object[]{appId, path, method});
            this.generateErrorResponse(resp, bodyString, errorMessage);
            return true;
        }
        return false;
    }

    private boolean validSubscriptionPermission(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String userToken;
        log.debug((Object)"*** \u958b\u59cb\u8a02\u95b1API\u670d\u52d9\u6b0a\u9650\u68c0\u67e5 ***");
        DWSecurityContext securityContext = DWSecurityContext.getSecurityContext();
        Map profile = securityContext.getProfile();
        String appId = this.servicePermissionConfig.getAppId();
        String path = this.getPath(req);
        String method = req.getMethod();
        String appToken = req.getHeader("digi-middleware-auth-app");
        if (Objects.isNull(appToken)) {
            appToken = securityContext.getAppToken();
        }
        if (Objects.isNull(appToken)) {
            log.warn((Object)"request header \u548c securityContext \u4e2d\u90fd\u6c92\u6709\u62ff\u5230\u8acb\u6c42\u65b9\u7684appToken!!!");
        }
        if (Objects.isNull(userToken = req.getHeader("token"))) {
            userToken = req.getHeader("digi-middleware-auth-user");
        }
        if (Objects.isNull(userToken)) {
            log.warn((Object)"request header\u90fd\u6c92\u6709\u62ff\u5230\u8acb\u6c42\u65b9\u7684userToken!!!");
        }
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("digi-middleware-auth-isv-id", req.getHeader("digi-middleware-auth-isv-id"));
        requestHeaders.put("digi-middleware-auth-isv-sign-arg", req.getHeader("digi-middleware-auth-isv-sign-arg"));
        SubscriptionApiPermissionParam param = new SubscriptionApiPermissionParam();
        param.setAppId(appId);
        param.setPath(path);
        param.setMethod(method);
        param.setAppToken(appToken);
        param.setTenantId(Objects.toString(profile.get("tenantId")));
        param.setTenantSid(Long.valueOf(Long.parseLong(Objects.toString(profile.get("tenantSid")))));
        param.setUserId(Objects.toString(profile.get("userId")));
        param.setUserSid(Long.valueOf(Long.parseLong(Objects.toString(profile.get("userSid")))));
        param.setUserToken(userToken);
        try {
            log.info((Object)("### \u8abf\u7528RAM\u9032\u884c\u8a02\u95b1API\u670d\u52d9\u6b0a\u9650\u9a57\u8b49 header => " + requestHeaders + ", \u53c3\u6578 => " + param + "\u3002"));
            Map result = this.authorizationVerifier.verifySubscriptionApiPermission(this.servicePermissionConfig.getRamHostUrl(), requestHeaders, param);
            log.info((Object)("### RAM\u9032\u884c\u8a02\u95b1API\u670d\u52d9\u6b0a\u9650\u9a57\u8b49\u7d50\u679c => " + result));
        }
        catch (Exception e) {
            String bodyString = e.getMessage();
            String errorMessage = DWApplicationMessageResourceBundleUtils.getString((String)ERROR_CODE, (Object[])new Object[]{appId, path, method});
            this.generateErrorResponse(resp, bodyString, errorMessage);
            return true;
        }
        return false;
    }

    private String getPath(HttpServletRequest req) {
        String eaiServiceName;
        Object originUrl;
        String path = "";
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (Objects.nonNull(requestAttributes)) {
            HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
            path = request.getRequestURI();
        }
        if (Objects.nonNull(originUrl = req.getAttribute("origin-url"))) {
            path = originUrl.toString();
        }
        if (Objects.nonNull(eaiServiceName = this.getEaiServiceName(req)) && path.endsWith("/eai")) {
            path = eaiServiceName;
        }
        return path;
    }

    private String getEaiServiceName(HttpServletRequest req) {
        String serviceInfo = req.getHeader("digi-service");
        if (Objects.isNull(serviceInfo)) {
            return null;
        }
        return EAIServiceInfoUtil.getServiceName((String)serviceInfo);
    }

    private void generateErrorResponse(HttpServletResponse response, String bodyString, String errorMessage) throws IOException {
        Gson gson = new Gson();
        HashMap<String, Object> error = new HashMap<String, Object>();
        error.put("sourceId", "DAP");
        error.put("errorType", "Business");
        error.put("errorCode", ERROR_CODE);
        error.put("errorMessage", errorMessage);
        Map iamResp = (Map)gson.fromJson(bodyString, Map.class);
        HashMap<String, Map> errorInstructors = new HashMap<String, Map>();
        errorInstructors.put("sourceAPI", iamResp);
        error.put("errorInstructors", errorInstructors);
        String jsonFromMap = gson.toJson(error);
        response.setHeader("Content-Type", "application/json");
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        response.getOutputStream().write(jsonFromMap.getBytes());
    }
}

