/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.registry.utils;

import com.digiwin.app.registry.data.MCText;
import com.digiwin.app.registry.enumeration.DOCleverItemType;
import com.digiwin.app.registry.enumeration.LocaleTag;
import org.apache.commons.lang3.StringUtils;

public class MetadataCacheUtils {
    private static String tagDate = "@date";
    private static String tagFormat = "@format";
    private static String tagBusinesskey = "@businesskey";
    private static String tagName = "@name";

    private MetadataCacheUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String getTypeName(int typeNum) {
        if (typeNum == DOCleverItemType.STRING.getKey()) {
            return DOCleverItemType.STRING.getName();
        }
        if (typeNum == DOCleverItemType.NUMBER.getKey()) {
            return DOCleverItemType.NUMBER.getName();
        }
        if (typeNum == DOCleverItemType.BOOLEAN.getKey()) {
            return DOCleverItemType.BOOLEAN.getName();
        }
        if (typeNum == DOCleverItemType.ARRAY.getKey()) {
            return DOCleverItemType.ARRAY.getName();
        }
        if (typeNum == DOCleverItemType.OBJECT.getKey()) {
            return DOCleverItemType.OBJECT.getName();
        }
        if (typeNum == DOCleverItemType.DATE.getKey()) {
            return DOCleverItemType.DATE.getName();
        }
        return "";
    }

    public static boolean isArray(int typeNum) {
        return StringUtils.equals((CharSequence)DOCleverItemType.ARRAY.getName(), (CharSequence)MetadataCacheUtils.getTypeName(typeNum));
    }

    public static boolean isObject(int typeNum) {
        return StringUtils.equals((CharSequence)DOCleverItemType.OBJECT.getName(), (CharSequence)MetadataCacheUtils.getTypeName(typeNum));
    }

    public static String createAPIName(String url, String method) {
        return StringUtils.replaceAll((String)url, (String)"/", (String)".") + "." + method;
    }

    public static String createAPIName(String name) {
        if (StringUtils.contains((CharSequence)name, (CharSequence)tagName)) {
            return StringUtils.substringBetween((String)name, (String)(tagName + "("), (String)")");
        }
        return name;
    }

    public static boolean isDateType(String description) {
        if (StringUtils.isBlank((CharSequence)description)) {
            return false;
        }
        return StringUtils.contains((CharSequence)description, (CharSequence)tagDate);
    }

    public static void setDateFormat(MCText text, String content) {
        if (StringUtils.contains((CharSequence)content, (CharSequence)tagFormat)) {
            String formatContent = StringUtils.substringAfter((String)content, (String)(tagFormat + ":"));
            if (formatContent == null) {
                formatContent = StringUtils.substringBetween((String)content, (String)(tagFormat + ":"), (String)";");
            }
            text.setZh_CN(text.getZh_CN() + " " + tagFormat + ":" + formatContent);
            text.setZh_TW(text.getZh_TW() + " " + tagFormat + ":" + formatContent);
            text.setEn(text.getEn() + " " + tagFormat + ":" + formatContent);
        }
    }

    public static String getStringByLanguageTag(String src, String locale) {
        String afterString = StringUtils.substringAfter((String)src, (String)(locale + "("));
        if (StringUtils.isBlank((CharSequence)afterString)) {
            return src;
        }
        afterString = MetadataCacheUtils.subStringBeforeAnyLanguageTag(afterString);
        return StringUtils.substringBeforeLast((String)afterString, (String)")");
    }

    private static String subStringBeforeAnyLanguageTag(String src) {
        String substring = src;
        for (LocaleTag tag : LocaleTag.values()) {
            String beforeSting = StringUtils.substringBefore((String)substring, (String)(tag.getTagName() + "("));
            if (!StringUtils.isNotBlank((CharSequence)beforeSting)) continue;
            substring = beforeSting;
        }
        return substring;
    }

    public static boolean isBussinessKey(String src) {
        if (StringUtils.isBlank((CharSequence)src)) {
            return false;
        }
        return StringUtils.contains((CharSequence)src, (CharSequence)tagBusinesskey);
    }
}

