/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common.config;

import com.digiwin.app.common.config.ConfigPolicy;
import com.digiwin.app.common.config.ConfigRepository;
import com.digiwin.app.common.config.DWConfigFileChangeListener;
import com.digiwin.app.common.config.DWLocalConfigRepository;
import com.digiwin.app.common.config.DWRemoteConfigRepository;
import com.digiwin.app.common.config.ReservedKeyFilter;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigPool {
    private static final String TAG = "[ConfigPool] ";
    private static final Log log = LogFactory.getLog(ConfigPool.class);
    private static ConfigPool instance;
    private boolean isRemoteConfigOn = false;
    private ConfigPolicy policy = ConfigPolicy.LOCAL_FIRST;
    private LinkedList<ConfigRepository> repositoryList = new LinkedList();
    private ConfigRepository local = new DWLocalConfigRepository();
    private ConfigRepository remote = new DWRemoteConfigRepository();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigPool getInstance() {
        if (instance != null) return instance;
        Class<ConfigPool> clazz = ConfigPool.class;
        synchronized (ConfigPool.class) {
            if (instance != null) return instance;
            instance = new ConfigPool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ConfigPool getInstance(ConfigPolicy policy, boolean isRemoteConfigOn) {
        if (instance == null) {
            Class<ConfigPool> clazz = ConfigPool.class;
            // MONITORENTER : com.digiwin.app.common.config.ConfigPool.class
            if (instance == null) {
                instance = new ConfigPool(policy, isRemoteConfigOn);
            }
            // MONITOREXIT : clazz
        }
        instance.setPolicyAndRemoteConfigOn(policy, isRemoteConfigOn);
        return instance;
    }

    private ConfigPool(ConfigPolicy policy, boolean isRemoteConfigOn) {
        this.policy = policy;
        this.isRemoteConfigOn = isRemoteConfigOn;
        this.sortRepositories();
    }

    private ConfigPool() {
        this(ConfigPolicy.LOCAL_FIRST, false);
    }

    public String toString() {
        return "[ConfigPool] policy: " + (Object)((Object)this.policy) + ", isRemoteConfigOn: " + this.isRemoteConfigOn;
    }

    public boolean addChangeListener(String propertiesName, DWConfigFileChangeListener listener) {
        return ((DWRemoteConfigRepository)this.remote).addChangeListener(propertiesName, listener);
    }

    public boolean addLog4j2XmlChangeListener(DWConfigFileChangeListener listener) {
        return ((DWRemoteConfigRepository)this.remote).addLog4j2XmlChangeListener(listener);
    }

    public String getLog4j2Xml() {
        for (int i = 0; i < this.repositoryList.size(); ++i) {
            ConfigRepository repository = this.repositoryList.get(i);
            String xmlString = repository.getLog4j2Xml();
            if (xmlString == null) continue;
            return xmlString;
        }
        return null;
    }

    public String getModuleSpringXml(String module, String xmlName) {
        for (int i = 0; i < this.repositoryList.size(); ++i) {
            ConfigRepository repository = this.repositoryList.get(i);
            String xmlString = repository.getModuleSpringXml(module, xmlName);
            if (xmlString != null) {
                return xmlString;
            }
            xmlString = repository.getPlatformModuleSpringXml(module, xmlName);
            if (xmlString == null) continue;
            return xmlString;
        }
        return null;
    }

    public String getApplicationSpringXml(String xmlName) {
        for (int i = 0; i < this.repositoryList.size(); ++i) {
            ConfigRepository repository = this.repositoryList.get(i);
            String xmlString = repository.getApplicationSpringXml(xmlName);
            if (xmlString == null) continue;
            return xmlString;
        }
        return null;
    }

    public String getPlatformSpringXml(String xmlName) {
        for (int i = 0; i < this.repositoryList.size(); ++i) {
            ConfigRepository repository = this.repositoryList.get(i);
            String xmlString = repository.getPlatformSpringXml(xmlName);
            if (xmlString == null) continue;
            return xmlString;
        }
        return null;
    }

    public Properties getProperties(String path, String propertiesName) {
        for (int i = 0; i < this.repositoryList.size(); ++i) {
            ConfigRepository repository = this.repositoryList.get(i);
            Properties properties = repository.getProperties(path, propertiesName);
            if (properties == null) continue;
            if (this.isRemoteConfigOn && repository instanceof DWLocalConfigRepository) {
                Properties originProperties = (Properties)properties.clone();
                ReservedKeyFilter.execute(properties);
                if (properties.size() == 0) continue;
                return originProperties;
            }
            if ("application".equalsIgnoreCase(propertiesName)) {
                Properties localProperties = this.local.getProperties(path, propertiesName);
                properties.putAll((Map<?, ?>)localProperties);
            }
            return properties;
        }
        return new Properties();
    }

    public ConfigPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(ConfigPolicy policy) {
        if (this.policy != policy) {
            this.policy = policy;
            this.sortRepositories();
        }
    }

    public boolean isRemoteConfigOn() {
        return this.isRemoteConfigOn;
    }

    public void setRemoteConfigOn(boolean isRemoteConfigOn) {
        if (this.isRemoteConfigOn != isRemoteConfigOn) {
            this.isRemoteConfigOn = isRemoteConfigOn;
            this.sortRepositories();
        }
    }

    public void setPolicyAndRemoteConfigOn(ConfigPolicy policy, boolean isRemoteConfigOn) {
        if (this.policy != policy || this.isRemoteConfigOn != isRemoteConfigOn) {
            this.policy = policy;
            this.isRemoteConfigOn = isRemoteConfigOn;
            this.sortRepositories();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortRepositories() {
        Class<ConfigPool> clazz = ConfigPool.class;
        synchronized (ConfigPool.class) {
            if (instance != null) {
                log.info((Object)instance);
            }
            this.repositoryList.clear();
            if (ConfigPolicy.LOCAL_FIRST.equals((Object)this.policy)) {
                this.repositoryList.addFirst(this.local);
                if (this.isRemoteConfigOn) {
                    this.repositoryList.addLast(this.remote);
                }
            } else {
                if (this.isRemoteConfigOn) {
                    this.repositoryList.addFirst(this.remote);
                }
                this.repositoryList.addLast(this.local);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

