/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common.config;

import com.digiwin.app.common.DWPathUtils;
import java.io.File;

public class PathAnalyzer {
    public static String getRemoteKey(String path, String propertiesName) {
        if (PathAnalyzer.isIgnorePath(path)) {
            return null;
        }
        String key = null;
        if (DWPathUtils.isApplicationConfPath(path)) {
            key = propertiesName;
        } else if (DWPathUtils.isApplicationModuleConfPath(path)) {
            String module = path.replace(DWPathUtils.getApplicationModulePath() + File.separator, "").replace(File.separator + "conf", "");
            key = module + "." + propertiesName;
        } else if (DWPathUtils.isPlatformConfPath(path)) {
            key = propertiesName;
        } else if (DWPathUtils.isPlatformModuleConfPath(path)) {
            String module = path.replace(DWPathUtils.getPlatformModulePath() + File.separator, "").replace(File.separator + "conf", "");
            key = module + "." + propertiesName;
        }
        return key;
    }

    private static boolean isIgnorePath(String path) {
        return path.contains("industry") || path.contains("customization");
    }
}

