/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common.config;

import com.ctrip.framework.apollo.ConfigFile;
import com.ctrip.framework.apollo.ConfigFileChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.model.ConfigFileChangeEvent;
import com.digiwin.app.common.config.ConfigRepository;
import com.digiwin.app.common.config.DWConfigFileChangeListener;
import com.digiwin.app.common.config.PathAnalyzer;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWRemoteConfigRepository
implements ConfigRepository {
    private static Log _log = LogFactory.getLog(DWRemoteConfigRepository.class);
    private static final String PLATFORMS_PREFIX = "platform.";
    private Map<String, ConfigFile> repositoryMap = new ConcurrentHashMap<String, ConfigFile>();
    private Map<String, DWConfigFileChangeListener> changeListenerMap = new ConcurrentHashMap<String, DWConfigFileChangeListener>();

    public boolean addChangeListener(String key, final DWConfigFileChangeListener listener) {
        if (key.toLowerCase().contains(".xml") || key.toLowerCase().contains(".properties")) {
            key = key.substring(0, key.lastIndexOf(46));
        }
        if (this.repositoryMap.containsKey(key)) {
            this.changeListenerMap.put(key, listener);
            ConfigFile configFile = this.repositoryMap.get(key);
            configFile.addChangeListener(new ConfigFileChangeListener(){

                public void onChange(ConfigFileChangeEvent changeEvent) {
                    String newValue = changeEvent.getNewValue();
                    String oldValue = changeEvent.getOldValue();
                    listener.onUpdate(newValue, oldValue);
                }
            });
            return true;
        }
        return false;
    }

    public boolean addLog4j2XmlChangeListener(DWConfigFileChangeListener listener) {
        return this.addChangeListener("log4j2.xml", listener);
    }

    @Override
    public String getLog4j2Xml() {
        String content = this.getLog4j2XmlConfigFileString("log4j2.xml");
        if (content == null) {
            return null;
        }
        return content;
    }

    @Override
    public String getPlatformModuleSpringXml(String module, String xmlName) {
        String content = this.getSpringXmlConfigFileString(module + "." + xmlName);
        if (content == null) {
            return null;
        }
        return content;
    }

    @Override
    public String getModuleSpringXml(String module, String xmlName) {
        String content = this.getSpringXmlConfigFileString(module + "." + xmlName);
        if (content == null) {
            return null;
        }
        return content;
    }

    @Override
    public String getApplicationSpringXml(String xmlName) {
        String content = this.getSpringXmlConfigFileString(xmlName);
        if (content == null) {
            return null;
        }
        return content;
    }

    @Override
    public String getPlatformSpringXml(String xmlName) {
        String content = this.getSpringXmlConfigFileString(PLATFORMS_PREFIX + xmlName);
        if (content == null) {
            return null;
        }
        return content;
    }

    @Override
    public Properties getProperties(String path, String propertiesName) {
        String key = PathAnalyzer.getRemoteKey(path, propertiesName);
        if (key == null) {
            return null;
        }
        String content = this.getConfigFileString(key, ConfigFileFormat.Properties);
        if (content == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(content));
        }
        catch (IOException e) {
            _log.error((Object)("parse remote properties error, error message=" + e.getMessage()));
            return null;
        }
        return properties;
    }

    private String getSpringXmlConfigFileString(String key) {
        return this.getXmlConfigFileString(key, false);
    }

    private String getLog4j2XmlConfigFileString(String key) {
        return this.getXmlConfigFileString(key, true);
    }

    private String getXmlConfigFileString(String key, boolean isKeep) {
        if (key.toLowerCase().contains(".xml")) {
            key = key.substring(0, key.lastIndexOf(46));
        }
        String content = this.getConfigFileString(key, ConfigFileFormat.XML);
        if (!isKeep && this.repositoryMap.containsKey(key)) {
            this.repositoryMap.remove(key);
        }
        return content;
    }

    private String getConfigFileString(String key, ConfigFileFormat configFileFormat) {
        String content;
        ConfigFile configFile;
        if (!this.repositoryMap.containsKey(key)) {
            configFile = ConfigService.getConfigFile((String)key, (ConfigFileFormat)configFileFormat);
            this.repositoryMap.put(key, configFile);
        }
        if ((content = (configFile = this.repositoryMap.get(key)).getContent()) == null) {
            configFile = null;
            this.repositoryMap.remove(key);
            return null;
        }
        return content;
    }
}

