/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.apollo.spring.annotation;

import com.ctrip.replica.apollo.build.ApolloInjector;
import com.ctrip.replica.apollo.spring.annotation.ApolloJsonValue;
import com.ctrip.replica.apollo.spring.annotation.ApolloProcessor;
import com.ctrip.replica.apollo.spring.property.PlaceholderHelper;
import com.ctrip.replica.apollo.spring.property.SpringValue;
import com.ctrip.replica.apollo.spring.property.SpringValueRegistry;
import com.ctrip.replica.apollo.spring.util.SpringInjector;
import com.ctrip.replica.apollo.util.ConfigUtil;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class ApolloJsonValueProcessor
extends ApolloProcessor
implements BeanFactoryAware {
    private static final Gson gson = new Gson();
    private final ConfigUtil configUtil = ApolloInjector.getInstance(ConfigUtil.class);
    private final PlaceholderHelper placeholderHelper = SpringInjector.getInstance(PlaceholderHelper.class);
    private final SpringValueRegistry springValueRegistry = SpringInjector.getInstance(SpringValueRegistry.class);
    private ConfigurableBeanFactory beanFactory;

    @Override
    protected void processField(Object bean, String beanName, Field field) {
        ApolloJsonValue apolloJsonValue = (ApolloJsonValue)AnnotationUtils.getAnnotation((AnnotatedElement)field, ApolloJsonValue.class);
        if (apolloJsonValue == null) {
            return;
        }
        String placeholder = apolloJsonValue.value();
        Object propertyValue = this.placeholderHelper.resolvePropertyValue(this.beanFactory, beanName, placeholder);
        if (!(propertyValue instanceof String)) {
            return;
        }
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        ReflectionUtils.setField((Field)field, (Object)bean, (Object)this.parseJsonValue((String)propertyValue, field.getGenericType()));
        field.setAccessible(accessible);
        if (this.configUtil.isAutoUpdateInjectedSpringPropertiesEnabled()) {
            Set<String> keys = this.placeholderHelper.extractPlaceholderKeys(placeholder);
            for (String key : keys) {
                SpringValue springValue = new SpringValue(key, placeholder, bean, beanName, field, true);
                this.springValueRegistry.register((BeanFactory)this.beanFactory, key, springValue);
            }
        }
    }

    @Override
    protected void processMethod(Object bean, String beanName, Method method) {
        ApolloJsonValue apolloJsonValue = (ApolloJsonValue)AnnotationUtils.getAnnotation((Method)method, ApolloJsonValue.class);
        if (apolloJsonValue == null) {
            return;
        }
        String placeHolder = apolloJsonValue.value();
        Object propertyValue = this.placeholderHelper.resolvePropertyValue(this.beanFactory, beanName, placeHolder);
        if (!(propertyValue instanceof String)) {
            return;
        }
        Type[] types = method.getGenericParameterTypes();
        Preconditions.checkArgument((types.length == 1 ? 1 : 0) != 0, (String)"Ignore @Value setter {}.{}, expecting 1 parameter, actual {} parameters", (Object[])new Object[]{bean.getClass().getName(), method.getName(), method.getParameterTypes().length});
        boolean accessible = method.isAccessible();
        method.setAccessible(true);
        ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{this.parseJsonValue((String)propertyValue, types[0])});
        method.setAccessible(accessible);
        if (this.configUtil.isAutoUpdateInjectedSpringPropertiesEnabled()) {
            Set<String> keys = this.placeholderHelper.extractPlaceholderKeys(placeHolder);
            for (String key : keys) {
                SpringValue springValue = new SpringValue(key, apolloJsonValue.value(), bean, beanName, method, true);
                this.springValueRegistry.register((BeanFactory)this.beanFactory, key, springValue);
            }
        }
    }

    private Object parseJsonValue(String json, Type targetType) {
        return gson.fromJson(json, targetType);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableBeanFactory)beanFactory;
    }
}

