/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.apollo.build;

import com.ctrip.replica.apollo.exceptions.ApolloConfigException;
import com.ctrip.replica.apollo.internals.DefaultInjector;
import com.ctrip.replica.apollo.internals.Injector;
import com.ctrip.replica.apollo.tracer.Tracer;

public class ApolloInjector {
    private static volatile Injector s_injector;
    private static final Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Injector getInjector() {
        if (s_injector == null) {
            Object object = lock;
            synchronized (object) {
                if (s_injector == null) {
                    try {
                        s_injector = new DefaultInjector();
                    }
                    catch (Throwable ex) {
                        ApolloConfigException exception = new ApolloConfigException("Unable to initialize Apollo Injector!", ex);
                        Tracer.logError(exception);
                        throw exception;
                    }
                }
            }
        }
        return s_injector;
    }

    public static <T> T getInstance(Class<T> clazz) {
        try {
            return ApolloInjector.getInjector().getInstance(clazz);
        }
        catch (Throwable ex) {
            Tracer.logError(ex);
            throw new ApolloConfigException(String.format("Unable to load instance for type %s!", clazz.getName()), ex);
        }
    }

    public static <T> T getInstance(Class<T> clazz, String name) {
        try {
            return ApolloInjector.getInjector().getInstance(clazz, name);
        }
        catch (Throwable ex) {
            Tracer.logError(ex);
            throw new ApolloConfigException(String.format("Unable to load instance for type %s and name %s !", clazz.getName(), name), ex);
        }
    }

    static {
        lock = new Object();
    }
}

