/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.apollo.internals;

import com.ctrip.replica.apollo.ConfigChangeListener;
import com.ctrip.replica.apollo.ConfigFile;
import com.ctrip.replica.apollo.ConfigFileChangeListener;
import com.ctrip.replica.apollo.core.utils.ApolloThreadFactory;
import com.ctrip.replica.apollo.enums.ConfigSourceType;
import com.ctrip.replica.apollo.enums.PropertyChangeType;
import com.ctrip.replica.apollo.internals.ConfigRepository;
import com.ctrip.replica.apollo.internals.RepositoryChangeListener;
import com.ctrip.replica.apollo.model.ConfigFileChangeEvent;
import com.ctrip.replica.apollo.tracer.Tracer;
import com.ctrip.replica.apollo.tracer.spi.Transaction;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractConfigFile
implements ConfigFile,
RepositoryChangeListener {
    private static ExecutorService m_executorService = Executors.newCachedThreadPool(ApolloThreadFactory.create("ConfigFile", true));
    protected final ConfigRepository m_configRepository;
    protected final String m_namespace;
    protected final AtomicReference<Properties> m_configProperties;
    private final List<ConfigFileChangeListener> m_listeners = Lists.newCopyOnWriteArrayList();
    private volatile ConfigSourceType m_sourceType = ConfigSourceType.NONE;

    public AbstractConfigFile(String namespace, ConfigRepository configRepository) {
        this.m_configRepository = configRepository;
        this.m_namespace = namespace;
        this.m_configProperties = new AtomicReference();
        this.initialize();
    }

    private void initialize() {
        try {
            this.m_configProperties.set(this.m_configRepository.getConfig());
            this.m_sourceType = this.m_configRepository.getSourceType();
        }
        catch (Throwable ex) {
            Tracer.logError(ex);
        }
        finally {
            this.m_configRepository.addChangeListener(this);
        }
    }

    @Override
    public String getNamespace() {
        return this.m_namespace;
    }

    protected abstract void update(Properties var1);

    @Override
    public synchronized void onRepositoryChange(String namespace, Properties newProperties) {
        if (newProperties.equals(this.m_configProperties.get())) {
            return;
        }
        Properties newConfigProperties = new Properties();
        newConfigProperties.putAll((Map<?, ?>)newProperties);
        String oldValue = this.getContent();
        this.update(newProperties);
        this.m_sourceType = this.m_configRepository.getSourceType();
        String newValue = this.getContent();
        PropertyChangeType changeType = PropertyChangeType.MODIFIED;
        if (oldValue == null) {
            changeType = PropertyChangeType.ADDED;
        } else if (newValue == null) {
            changeType = PropertyChangeType.DELETED;
        }
        this.fireConfigChange(new ConfigFileChangeEvent(this.m_namespace, oldValue, newValue, changeType));
        Tracer.logEvent("Apollo.Client.ConfigChanges", this.m_namespace);
    }

    @Override
    public void addChangeListener(ConfigFileChangeListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    @Override
    public boolean removeChangeListener(ConfigChangeListener listener) {
        return this.m_listeners.remove(listener);
    }

    @Override
    public ConfigSourceType getSourceType() {
        return this.m_sourceType;
    }

    private void fireConfigChange(final ConfigFileChangeEvent changeEvent) {
        for (final ConfigFileChangeListener listener : this.m_listeners) {
            m_executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String listenerName = listener.getClass().getName();
                    Transaction transaction = Tracer.newTransaction("Apollo.ConfigFileChangeListener", listenerName);
                    try {
                        listener.onChange(changeEvent);
                        transaction.setStatus("0");
                    }
                    catch (Throwable ex) {
                        transaction.setStatus(ex);
                        Tracer.logError(ex);
                    }
                    finally {
                        transaction.complete();
                    }
                }
            });
        }
    }
}

