/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.apollo.internals;

import com.ctrip.replica.apollo.internals.ConfigRepository;
import com.ctrip.replica.apollo.internals.RepositoryChangeListener;
import com.ctrip.replica.apollo.tracer.Tracer;
import com.ctrip.replica.apollo.util.ExceptionUtil;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Properties;

public abstract class AbstractConfigRepository
implements ConfigRepository {
    private List<RepositoryChangeListener> m_listeners = Lists.newCopyOnWriteArrayList();

    protected boolean trySync() {
        try {
            this.sync();
            return true;
        }
        catch (Throwable ex) {
            Tracer.logEvent("ApolloConfigException", ExceptionUtil.getDetailMessage(ex));
            return false;
        }
    }

    protected abstract void sync();

    @Override
    public void addChangeListener(RepositoryChangeListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    @Override
    public void removeChangeListener(RepositoryChangeListener listener) {
        this.m_listeners.remove(listener);
    }

    protected void fireRepositoryChange(String namespace, Properties newProperties) {
        for (RepositoryChangeListener listener : this.m_listeners) {
            try {
                listener.onRepositoryChange(namespace, newProperties);
            }
            catch (Throwable ex) {
                Tracer.logError(ex);
            }
        }
    }
}

