/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.apollo.internals;

import com.ctrip.replica.apollo.exceptions.ApolloConfigException;
import com.ctrip.replica.apollo.internals.ConfigManager;
import com.ctrip.replica.apollo.internals.ConfigServiceLocator;
import com.ctrip.replica.apollo.internals.DefaultConfigManager;
import com.ctrip.replica.apollo.internals.Injector;
import com.ctrip.replica.apollo.internals.RemoteConfigLongPollService;
import com.ctrip.replica.apollo.spi.ConfigFactory;
import com.ctrip.replica.apollo.spi.ConfigFactoryManager;
import com.ctrip.replica.apollo.spi.ConfigRegistry;
import com.ctrip.replica.apollo.spi.DefaultConfigFactory;
import com.ctrip.replica.apollo.spi.DefaultConfigFactoryManager;
import com.ctrip.replica.apollo.spi.DefaultConfigRegistry;
import com.ctrip.replica.apollo.tracer.Tracer;
import com.ctrip.replica.apollo.util.ConfigUtil;
import com.ctrip.replica.apollo.util.http.HttpUtil;
import com.ctrip.replica.apollo.util.yaml.YamlParser;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Singleton;

public class DefaultInjector
implements Injector {
    private com.google.inject.Injector m_injector;

    public DefaultInjector() {
        try {
            this.m_injector = Guice.createInjector((Module[])new Module[]{new ApolloModule()});
        }
        catch (Throwable ex) {
            ApolloConfigException exception = new ApolloConfigException("Unable to initialize Guice Injector!", ex);
            Tracer.logError(exception);
            throw exception;
        }
    }

    @Override
    public <T> T getInstance(Class<T> clazz) {
        try {
            return (T)this.m_injector.getInstance(clazz);
        }
        catch (Throwable ex) {
            Tracer.logError(ex);
            throw new ApolloConfigException(String.format("Unable to load instance for %s!", clazz.getName()), ex);
        }
    }

    @Override
    public <T> T getInstance(Class<T> clazz, String name) {
        return null;
    }

    private static class ApolloModule
    extends AbstractModule {
        private ApolloModule() {
        }

        protected void configure() {
            this.bind(ConfigManager.class).to(DefaultConfigManager.class).in(Singleton.class);
            this.bind(ConfigFactoryManager.class).to(DefaultConfigFactoryManager.class).in(Singleton.class);
            this.bind(ConfigRegistry.class).to(DefaultConfigRegistry.class).in(Singleton.class);
            this.bind(ConfigFactory.class).to(DefaultConfigFactory.class).in(Singleton.class);
            this.bind(ConfigUtil.class).in(Singleton.class);
            this.bind(HttpUtil.class).in(Singleton.class);
            this.bind(ConfigServiceLocator.class).in(Singleton.class);
            this.bind(RemoteConfigLongPollService.class).in(Singleton.class);
            this.bind(YamlParser.class).in(Singleton.class);
        }
    }
}

