/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.apollo.internals;

import com.ctrip.replica.apollo.PropertiesCompatibleConfigFile;
import com.ctrip.replica.apollo.build.ApolloInjector;
import com.ctrip.replica.apollo.core.enums.ConfigFileFormat;
import com.ctrip.replica.apollo.exceptions.ApolloConfigException;
import com.ctrip.replica.apollo.internals.ConfigRepository;
import com.ctrip.replica.apollo.internals.PlainTextConfigFile;
import com.ctrip.replica.apollo.tracer.Tracer;
import com.ctrip.replica.apollo.util.ExceptionUtil;
import com.ctrip.replica.apollo.util.yaml.YamlParser;
import java.util.Properties;

public class YamlConfigFile
extends PlainTextConfigFile
implements PropertiesCompatibleConfigFile {
    private volatile Properties cachedProperties;

    public YamlConfigFile(String namespace, ConfigRepository configRepository) {
        super(namespace, configRepository);
        this.tryTransformToProperties();
    }

    @Override
    public ConfigFileFormat getConfigFileFormat() {
        return ConfigFileFormat.YAML;
    }

    @Override
    protected void update(Properties newProperties) {
        super.update(newProperties);
        this.tryTransformToProperties();
    }

    @Override
    public Properties asProperties() {
        if (this.cachedProperties == null) {
            this.transformToProperties();
        }
        return this.cachedProperties;
    }

    private boolean tryTransformToProperties() {
        try {
            this.transformToProperties();
            return true;
        }
        catch (Throwable ex) {
            Tracer.logEvent("ApolloConfigException", ExceptionUtil.getDetailMessage(ex));
            return false;
        }
    }

    private synchronized void transformToProperties() {
        this.cachedProperties = this.toProperties();
    }

    private Properties toProperties() {
        if (!this.hasContent()) {
            return new Properties();
        }
        try {
            return ApolloInjector.getInstance(YamlParser.class).yamlToProperties(this.getContent());
        }
        catch (Throwable ex) {
            ApolloConfigException exception = new ApolloConfigException("Parse yaml file content failed for namespace: " + this.m_namespace, ex);
            Tracer.logError(exception);
            throw exception;
        }
    }
}

