/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.apollo.spi;

import com.ctrip.replica.apollo.Config;
import com.ctrip.replica.apollo.ConfigFile;
import com.ctrip.replica.apollo.PlatformConfigService;
import com.ctrip.replica.apollo.PropertiesCompatibleConfigFile;
import com.ctrip.replica.apollo.build.ApolloInjector;
import com.ctrip.replica.apollo.core.enums.ConfigFileFormat;
import com.ctrip.replica.apollo.internals.DefaultConfig;
import com.ctrip.replica.apollo.internals.JsonConfigFile;
import com.ctrip.replica.apollo.internals.LocalFileConfigRepository;
import com.ctrip.replica.apollo.internals.PropertiesCompatibleFileConfigRepository;
import com.ctrip.replica.apollo.internals.PropertiesConfigFile;
import com.ctrip.replica.apollo.internals.RemoteConfigRepository;
import com.ctrip.replica.apollo.internals.TxtConfigFile;
import com.ctrip.replica.apollo.internals.XmlConfigFile;
import com.ctrip.replica.apollo.internals.YamlConfigFile;
import com.ctrip.replica.apollo.internals.YmlConfigFile;
import com.ctrip.replica.apollo.spi.ConfigFactory;
import com.ctrip.replica.apollo.util.ConfigUtil;

public class DefaultConfigFactory
implements ConfigFactory {
    private ConfigUtil m_configUtil = ApolloInjector.getInstance(ConfigUtil.class);

    @Override
    public Config create(String namespace) {
        ConfigFileFormat format = this.determineFileFormat(namespace);
        if (ConfigFileFormat.isPropertiesCompatible(format)) {
            return new DefaultConfig(namespace, this.createPropertiesCompatibleFileConfigRepository(namespace, format));
        }
        return new DefaultConfig(namespace, this.createLocalConfigRepository(namespace));
    }

    @Override
    public ConfigFile createConfigFile(String namespace, ConfigFileFormat configFileFormat) {
        LocalFileConfigRepository configRepository = this.createLocalConfigRepository(namespace);
        switch (configFileFormat) {
            case Properties: {
                return new PropertiesConfigFile(namespace, configRepository);
            }
            case XML: {
                return new XmlConfigFile(namespace, configRepository);
            }
            case JSON: {
                return new JsonConfigFile(namespace, configRepository);
            }
            case YAML: {
                return new YamlConfigFile(namespace, configRepository);
            }
            case YML: {
                return new YmlConfigFile(namespace, configRepository);
            }
            case TXT: {
                return new TxtConfigFile(namespace, configRepository);
            }
        }
        return null;
    }

    LocalFileConfigRepository createLocalConfigRepository(String namespace) {
        if (this.m_configUtil.isInLocalMode()) {
            return new LocalFileConfigRepository(namespace);
        }
        return new LocalFileConfigRepository(namespace, this.createRemoteConfigRepository(namespace));
    }

    RemoteConfigRepository createRemoteConfigRepository(String namespace) {
        return new RemoteConfigRepository(namespace);
    }

    PropertiesCompatibleFileConfigRepository createPropertiesCompatibleFileConfigRepository(String namespace, ConfigFileFormat format) {
        String actualNamespaceName = this.trimNamespaceFormat(namespace, format);
        PropertiesCompatibleConfigFile configFile = (PropertiesCompatibleConfigFile)PlatformConfigService.getConfigFile(actualNamespaceName, format);
        return new PropertiesCompatibleFileConfigRepository(configFile);
    }

    ConfigFileFormat determineFileFormat(String namespaceName) {
        String lowerCase = namespaceName.toLowerCase();
        for (ConfigFileFormat format : ConfigFileFormat.values()) {
            if (!lowerCase.endsWith("." + format.getValue())) continue;
            return format;
        }
        return ConfigFileFormat.Properties;
    }

    String trimNamespaceFormat(String namespaceName, ConfigFileFormat format) {
        String extension = "." + format.getValue();
        if (!namespaceName.toLowerCase().endsWith(extension)) {
            return namespaceName;
        }
        return namespaceName.substring(0, namespaceName.length() - extension.length());
    }
}

