/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common.config;

import com.digiwin.app.common.DWPathUtils;
import com.digiwin.app.common.config.ConfigType;
import com.digiwin.app.common.config.KeyPojo;
import java.io.File;

public class PathAnalyzer {
    public static KeyPojo getRemoteKey(String path, String propertiesName) {
        KeyPojo keyPojo = new KeyPojo();
        if (PathAnalyzer.isIgnorePath(path)) {
            return keyPojo;
        }
        String key = null;
        if (DWPathUtils.isApplicationConfPath(path)) {
            key = propertiesName;
            keyPojo.setConfigType(ConfigType.APPLICATION);
        } else if (DWPathUtils.isApplicationModuleConfPath(path)) {
            String module = path.replace(DWPathUtils.getApplicationModulePath() + File.separator, "").replace(File.separator + "conf", "");
            key = module + "." + propertiesName;
            keyPojo.setConfigType(ConfigType.APPLICATION);
        } else if (DWPathUtils.isPlatformConfPath(path)) {
            key = propertiesName;
            keyPojo.setConfigType(ConfigType.PLATFORM);
        } else if (DWPathUtils.isPlatformModuleConfPath(path)) {
            String module = path.replace(DWPathUtils.getPlatformModulePath() + File.separator, "").replace(File.separator + "conf", "");
            key = module + "." + propertiesName;
            keyPojo.setConfigType(ConfigType.PLATFORM);
        }
        keyPojo.setKey(key);
        return keyPojo;
    }

    private static boolean isIgnorePath(String path) {
        return path.contains("industry") || path.contains("customization");
    }
}

